package com.ejianc.business.labor.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.labor.service.IIdCardService;
import com.ejianc.business.labor.vo.IdentityCardInfoVO;
import com.ejianc.foundation.usercenter.api.IFaceAndIdCardService;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

import javax.annotation.Resource;

/**
 * 身份证ocr识别接口实现
 *
 * @author baipengyan
 * @version 1.0
 * @since JDK 1.8
 */
@Service(value = "idCardService")
public class IdCardServiceImpl implements IIdCardService {
	private final Logger logger = LoggerFactory.getLogger(this.getClass());

	@Resource
	private IFaceAndIdCardService faceAndIdCardService;

	/**
	 * 校验身份证以及身份证信息识别
	 *
	 * @param imageUrl 身份证阿里oss存储在线地址
	 * @param side     face：人像面  back：国徽面
	 *
	 * @return {@link IdentityCardInfoVO}
	 */
	@Override
	public IdentityCardInfoVO checkAndRecognizeIdentityCardInfo(String imageUrl, String side) {
		Assert.hasText(imageUrl, "身份证阿里oss存储在线地址，不能为空！");
		Assert.hasText(side, "身份证人像面或者国徽面，不能为空！");
		logger.info("校验身份证以及身份证信息识别，side={} imageUrl={}", side, imageUrl);

		// 身份证信息识别
		CommonResponse<JSONObject> response = faceAndIdCardService.recognizeIdentityCardInfo(imageUrl, side);
		if (!response.isSuccess()) {
			logger.info("身份证信息识别失败，失败原因：{}", response.getMsg());
			throw new BusinessException(response.getMsg());
		}

		JSONObject data = response.getData();
		return JSON.parseObject(data.toJSONString(), IdentityCardInfoVO.class);
	}
}
