package com.ejianc.business.other.henger.controller;

import java.io.Serializable;

import com.ejianc.business.labor.bean.WorkRecordEntity;
import com.ejianc.business.labor.enums.WorkerConsts;
import com.ejianc.business.labor.service.IWorkRecordService;
import com.ejianc.business.labor.vo.WorkRecordVO;
import com.ejianc.business.other.enums.ServiceTypeEnum;
import com.ejianc.business.other.henger.service.HengErPersonApiService;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.*;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.auth.session.SessionManager;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.other.henger.bean.HengErTaskEntity;
import com.ejianc.business.other.henger.service.IHengErTaskService;
import com.ejianc.business.other.henger.vo.HengErTaskVO;

/**
 * 恒尔-任务列表
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("hengErTask")
public class HengErTaskController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "Invoice_Open_Apply_Code";//此处需要根据实际修改

    @Autowired
    private IHengErTaskService service;

    @Autowired
    private SessionManager sessionManager;

    @Autowired
    private HengErPersonApiService hengErPersonApiService;

    @Autowired
    private IWorkRecordService workRecordService;


    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<HengErTaskVO> saveOrUpdate(@RequestBody HengErTaskVO saveOrUpdateVO) {
    	HengErTaskEntity entity = BeanMapper.map(saveOrUpdateVO, HengErTaskEntity.class);
//    	if(entity.getId() == null || entity.getId() == 0){
//            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE,InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
//            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
//            if(billCode.isSuccess()) {
//                entity.setCode(billCode.getData());//此处需要根据实际修改 删除本行或者下一行
//                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
//            }else{
//                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
//            }
//        }
    	service.saveOrUpdate(entity, false);
    	HengErTaskVO vo = BeanMapper.map(entity, HengErTaskVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<HengErTaskVO> queryDetail(Long id) {
    	HengErTaskEntity entity = service.selectById(id);
    	HengErTaskVO vo = BeanMapper.map(entity, HengErTaskVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<HengErTaskVO> vos) {
        if(ListUtil.isNotEmpty(vos)){
            for (HengErTaskVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
            }
        }
        service.removeByIds(vos.stream().map(HengErTaskVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<HengErTaskVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();

        IPage<HengErTaskEntity> page = service.queryPage(param,false);
        IPage<HengErTaskVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), HengErTaskVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<HengErTaskEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("HengErTask-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/refHengErTaskData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<HengErTaskVO>> refHengErTaskData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<HengErTaskEntity> page = service.queryPage(param,false);
        IPage<HengErTaskVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), HengErTaskVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }

    /**
     * @Description resetTask
     *      根据taskId重新生成任务
     * @Param [ids]
     */
    @RequestMapping(value = "/resetByTaskId", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<List<String>> resetTask(@RequestBody List<HengErTaskVO> vos) {
        List<Long> ids = vos.stream().map(HengErTaskVO::getId).collect(Collectors.toList());
        List<String> errorList = new ArrayList<>();


        if(ListUtil.isNotEmpty(ids)){
            QueryParam queryParam = new QueryParam();
            queryParam.getParams().put("id",new Parameter(QueryParam.IN,ids));
            List<HengErTaskEntity> taskEntities = service.queryList(queryParam);
            for (HengErTaskEntity taskEntity : taskEntities) {

                if(taskEntity.getServiceType().equals(ServiceTypeEnum.单个名单添加.getStatus())){
                    WorkRecordEntity workRecordEntity = workRecordService.selectById(taskEntity.getServiceId());
                    if(workRecordEntity == null){
                        errorList.add("任务Id["+taskEntity.getTaskId()+"]中,人员不存在!");
                        logger.error("任务Id["+taskEntity.getTaskId()+"]中,人员不存在!");
                    }
                    if(workRecordEntity.getEnterExitState() != WorkerConsts.WorkStateEnum.已入场.getCode()){
                        errorList.add("任务Id["+taskEntity.getTaskId()+"]中,"+workRecordEntity.getName()+"人员不在场!");
                        logger.error("任务Id["+taskEntity.getTaskId()+"]中,"+workRecordEntity.getName()+"人员不在场!");
                    }

                    WorkRecordVO workRecordVO = BeanMapper.map(workRecordEntity, WorkRecordVO.class);
                    JSONObject serviceRequest = hengErPersonApiService.getAddCom(workRecordVO, taskEntity.getEquipSn());
                    service.addTaskByType(taskEntity.getEquipSn(),taskEntity.getServiceId(),taskEntity.getServiceType(),serviceRequest.toJSONString());

                }
                else if(taskEntity.getServiceType().equals(ServiceTypeEnum.单个名单删除.getStatus())){
                    service.addTaskByType(taskEntity.getEquipSn(),taskEntity.getServiceId(),taskEntity.getServiceType(),taskEntity.getQueryParam());

                }
                else if(taskEntity.getServiceType().equals(ServiceTypeEnum.多个名单查询.getStatus())){
                    service.addTaskByType(taskEntity.getEquipSn(),taskEntity.getServiceId(),taskEntity.getServiceType(),taskEntity.getQueryParam());
                }

            }
        }
        return CommonResponse.success("任务添加成功！",errorList);
    }

    /**
     * 新增-批量名单查询任务队列
     * -根据设备查询人员名单，每次100条
     * @param equipSn
     * @param beginNO
     * @return
     */
    @RequestMapping(value = "/searchPersonListTask", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<String> searchPersonListTask(String equipSn,Integer beginNO) {
        JSONObject queryParam = hengErPersonApiService.getSearchPersonListCom(equipSn,beginNO);
        service.addTaskByType(equipSn,null,ServiceTypeEnum.多个名单查询.getStatus(),queryParam.toJSONString());
        return CommonResponse.success("任务添加成功！更新数据有5分钟延时，请稍后再进行查看！");

    }
    /**
     * 新增-单个名单查询任务队列
     * @param equipSn
     * @param workerId
     * @param equipPersonId 为空则新增，不为空则更新
     * @return
     */
    @RequestMapping(value = "/searchPersonTask", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<String> searchPersonTask(String equipSn,Long workerId,Long equipPersonId  ) {
        JSONObject queryParam = hengErPersonApiService.getSearchPersonCom(equipSn,workerId);
        service.addTaskByType(equipSn,equipPersonId,ServiceTypeEnum.单个名单查询.getStatus(),queryParam.toJSONString());
        return CommonResponse.success("任务添加成功！更新数据有5分钟延时，请稍后再进行查看！");

    }

    /**
     * 新增-添加人员任务队列
     * @param equipSn
     * @param workRecordId
     * @return
     */
    @RequestMapping(value = "/addPersonTask", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<String> updateEquipPersonById(String equipSn,Long workRecordId) {

        WorkRecordEntity workRecordEntity = workRecordService.selectById(workRecordId);
        WorkRecordVO vo = BeanMapper.map(workRecordEntity, WorkRecordVO.class);
        JSONObject queryParam = hengErPersonApiService.getAddCom(vo,equipSn);
        service.addTaskByType(equipSn,workRecordId,ServiceTypeEnum.单个名单添加.getStatus(),queryParam.toJSONString());
        return CommonResponse.success("任务添加成功！更新数据有5分钟延时，请稍后再进行查看！");

    }
}
