/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.cost.controller.api;

import com.ejianc.business.cost.bean.DatasummaryEntity;
import com.ejianc.business.cost.bean.GasAndElectricEntity;
import com.ejianc.business.cost.service.IDatasummaryService;
import com.ejianc.business.cost.service.IGasAndElectricService;
import com.ejianc.business.cost.service.IMaterialBuyService;
import com.ejianc.business.cost.service.IMaterialConsumeService;
import com.ejianc.business.openapi.cost.vo.GasAndElectricVO;
import com.ejianc.business.openapi.cost.vo.ProductDataVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/cost/synchronizedataApi"})
public class SynchronizeDataApi {
    @Autowired
    private IDatasummaryService service;
    @Autowired
    private IGasAndElectricService gasAndElectricService;
    @Autowired
    private IMaterialConsumeService consumeService;
    @Autowired
    private IMaterialBuyService materialBuyService;

    @RequestMapping(value={"/synchronizedata"}, method={RequestMethod.POST})
    @ResponseBody
    public void synchronizeData(@RequestBody List<ProductDataVO> productDataVOS) {
        List<DatasummaryEntity> datasummaryEntities = this.service.synchronizeData(productDataVOS);
        DatasummaryEntity datasummaryEntity = datasummaryEntities.get(0);
        String orgId = datasummaryEntity.getOrgId().toString();
        String productTime = datasummaryEntity.getProductTime().toString();
        this.consumeService.generateMaterialConsume(productTime, orgId);
        this.materialBuyService.generateMaterialBuy(productTime, orgId);
    }

    @RequestMapping(value={"/synchronizegasdata"}, method={RequestMethod.POST})
    @ResponseBody
    public void synchronizeGasData(@RequestBody GasAndElectricVO gasAndElectricVO) {
        GasAndElectricEntity entity = (GasAndElectricEntity)((Object)BeanMapper.map((Object)gasAndElectricVO, GasAndElectricEntity.class));
        this.gasAndElectricService.save((Object)entity);
    }
}

