/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.cost.service.impl;

import com.ejianc.business.cost.bean.MaterialBuyEntity;
import com.ejianc.business.cost.mapper.MaterialBuyMapper;
import com.ejianc.business.cost.service.IDatasummaryService;
import com.ejianc.business.cost.service.IMaterialBuyService;
import com.ejianc.business.cost.vo.MaterialUseTotalVO;
import com.ejianc.business.purchasingmanagement.api.SelectApi;
import com.ejianc.business.purchasingmanagement.vo.MaterialAcceptanceVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="materialBuyService")
public class MaterialBuyServiceImpl
extends BaseServiceImpl<MaterialBuyMapper, MaterialBuyEntity>
implements IMaterialBuyService {
    @Autowired
    private IDatasummaryService datasummaryService;
    @Autowired
    private SelectApi api;
    @Autowired
    private IMaterialBuyService service;

    @Override
    public void generateMaterialBuy(String productTime, String orgId) {
        ArrayList<MaterialBuyEntity> materialBuyEntities = new ArrayList<MaterialBuyEntity>();
        List<MaterialUseTotalVO> materialUseTotalVOS = this.datasummaryService.queryMaterialUseTotal(productTime, orgId);
        if (!materialBuyEntities.isEmpty()) {
            for (MaterialUseTotalVO materialUseTotalVO : materialUseTotalVOS) {
                CommonResponse commonResponse = this.api.queryMaterialAcceptance(materialUseTotalVO.getMaterialId().toString(), materialUseTotalVO.getProductTime().toString());
                if (commonResponse.getCode() != 0) continue;
                MaterialAcceptanceVO data = (MaterialAcceptanceVO)commonResponse.getData();
                MaterialBuyEntity entity = (MaterialBuyEntity)((Object)BeanMapper.map((Object)materialUseTotalVO, MaterialBuyEntity.class));
                entity.setBuyDate(materialUseTotalVO.getProductTime());
                entity.setAccount(data.getAcceptanceQuantity());
                entity.setAmount(data.getAmount());
                entity.setPrice(data.getPrice());
                materialBuyEntities.add(entity);
            }
        }
        this.service.saveBatch(materialBuyEntities);
    }
}

