/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.cost.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.cost.bean.MaterialConsumeEntity;
import com.ejianc.business.cost.bean.MaterialStartInventoryEntity;
import com.ejianc.business.cost.mapper.MaterialConsumeMapper;
import com.ejianc.business.cost.service.IDatasummaryService;
import com.ejianc.business.cost.service.IMaterialConsumeService;
import com.ejianc.business.cost.service.IMaterialStartInventoryService;
import com.ejianc.business.cost.vo.MaterialUseTotalVO;
import com.ejianc.business.purchasingmanagement.api.SelectApi;
import com.ejianc.business.purchasingmanagement.vo.MaterialAcceptanceVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="materialConsumeService")
public class MaterialConsumeServiceImpl
extends BaseServiceImpl<MaterialConsumeMapper, MaterialConsumeEntity>
implements IMaterialConsumeService {
    @Autowired
    IMaterialStartInventoryService materialStartInventoryService;
    @Autowired
    private IDatasummaryService datasummaryService;
    @Autowired
    private SelectApi api;
    @Autowired
    private IMaterialConsumeService materialConsumeService;

    @Override
    public void generateMaterialConsume(String productTime, String orgId) {
        ArrayList<MaterialConsumeEntity> materialConsumeEntities = new ArrayList<MaterialConsumeEntity>();
        List<MaterialUseTotalVO> materialUseTotalVOS = this.datasummaryService.queryMaterialUseTotal(productTime, orgId);
        if (!materialUseTotalVOS.isEmpty()) {
            for (MaterialUseTotalVO materialUseTotalVO : materialUseTotalVOS) {
                BigDecimal amountSum;
                BigDecimal accountSum;
                CommonResponse commonResponse = this.api.queryMaterialAcceptance(materialUseTotalVO.getMaterialId().toString(), materialUseTotalVO.getProductTime().toString());
                if (commonResponse.getCode() != 0) continue;
                MaterialAcceptanceVO data = (MaterialAcceptanceVO)commonResponse.getData();
                QueryWrapper query = new QueryWrapper();
                ((QueryWrapper)query.eq((Object)"material_id", (Object)materialUseTotalVO.getMaterialId())).orderByDesc((Object)"create_time");
                List list = this.materialStartInventoryService.list((Wrapper)query);
                if (list.isEmpty()) continue;
                MaterialStartInventoryEntity materialStartInventoryEntity = (MaterialStartInventoryEntity)((Object)list.get(0));
                MaterialConsumeEntity materialConsumeEntity = (MaterialConsumeEntity)((Object)BeanMapper.map((Object)materialUseTotalVO, MaterialConsumeEntity.class));
                materialConsumeEntity.setConsumeDate(materialUseTotalVO.getProductTime());
                materialConsumeEntity.setAccount(materialUseTotalVO.getMaterialUseTotal());
                if (data != null) {
                    accountSum = materialStartInventoryEntity.getMaterialAccount().add(data.getAcceptanceQuantity());
                    amountSum = materialStartInventoryEntity.getInventoryAmount().add(data.getAmount());
                } else {
                    accountSum = materialStartInventoryEntity.getMaterialAccount();
                    amountSum = materialStartInventoryEntity.getInventoryAmount();
                }
                materialConsumeEntity.setPrice(amountSum.divide(accountSum, 2, 4));
                materialConsumeEntity.setAmount(materialConsumeEntity.getAccount().subtract(materialConsumeEntity.getPrice()));
                materialConsumeEntities.add(materialConsumeEntity);
            }
        }
        this.materialConsumeService.saveBatch(materialConsumeEntities);
    }
}

