/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.cost.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.cost.bean.MaterialInventorySummaryEntity;
import com.ejianc.business.cost.bean.MaterialStartInventoryEntity;
import com.ejianc.business.cost.mapper.MaterialInventorySummaryMapper;
import com.ejianc.business.cost.service.IMaterialInventorySummaryService;
import com.ejianc.business.cost.service.IMaterialStartInventoryService;
import com.ejianc.business.cost.vo.MaterialInventorySummaryVO;
import com.ejianc.business.cost.vo.MaterialInventoryVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.math.BigDecimal;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="materialInventorySummaryService")
public class MaterialInventorySummaryServiceImpl
extends BaseServiceImpl<MaterialInventorySummaryMapper, MaterialInventorySummaryEntity>
implements IMaterialInventorySummaryService {
    @Autowired
    IMaterialStartInventoryService service;
    @Autowired
    IMaterialInventorySummaryService materialInventorySummaryService;
    @Autowired
    private IBillCodeApi billCodeApi;
    private static final String BILL_CODE = "materialInventory-sum";

    @Override
    public void saveMaterialInventorySummaryEntity(MaterialInventoryVO materialInventoryVO) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"material_Id", (Object)materialInventoryVO.getMaterialId());
        queryWrapper.eq((Object)"category_id", (Object)materialInventoryVO.getCategoryId());
        queryWrapper.eq((Object)"material_varieties_id", (Object)materialInventoryVO.getMaterialVarietiesId());
        queryWrapper.eq((Object)"org_id", (Object)materialInventoryVO.getOrgId());
        queryWrapper.orderByAsc((Object)"create_time");
        List list = this.service.list((Wrapper)queryWrapper);
        if (!list.isEmpty()) {
            MaterialStartInventoryEntity materialStartInventoryEntity = (MaterialStartInventoryEntity)((Object)list.get(0));
            MaterialInventorySummaryEntity materialInventorySummaryEntity = new MaterialInventorySummaryEntity();
            materialInventorySummaryEntity.setMaterialId(materialStartInventoryEntity.getMaterialId());
            materialInventorySummaryEntity.setMaterialName(materialStartInventoryEntity.getMaterialName());
            materialInventorySummaryEntity.setMaterialVarietiesId(materialStartInventoryEntity.getMaterialVarietiesId());
            materialInventorySummaryEntity.setMaterialVarietiesName(materialStartInventoryEntity.getMaterialVarietiesName());
            materialInventorySummaryEntity.setInventoryQuantity(materialInventoryVO.getMaterialAccount());
            materialInventorySummaryEntity.setCurrentQuantity(materialStartInventoryEntity.getMaterialAccount());
            materialInventorySummaryEntity.setPrice(materialStartInventoryEntity.getInventoryUnitPrice());
            BigDecimal price = materialInventorySummaryEntity.getPrice();
            BigDecimal inventoryQuantity = materialInventorySummaryEntity.getInventoryQuantity();
            BigDecimal inventoryAccount = price.multiply(inventoryQuantity);
            materialInventorySummaryEntity.setInventoryAccount(inventoryAccount);
            BigDecimal currentQuantity = materialInventorySummaryEntity.getCurrentQuantity();
            BigDecimal currentAmount = price.multiply(currentQuantity);
            materialInventorySummaryEntity.setCurrentAmount(currentAmount);
            BigDecimal profitLossAmount = inventoryAccount.subtract(currentAmount);
            materialInventorySummaryEntity.setProfitLossAmount(profitLossAmount);
            BigDecimal profitLossQuantity = inventoryQuantity.subtract(currentQuantity);
            materialInventorySummaryEntity.setProfitLossQuantity(profitLossQuantity);
            materialInventorySummaryEntity.setRemark(materialStartInventoryEntity.getRemark());
            materialInventorySummaryEntity.setOrgId(materialStartInventoryEntity.getOrgId());
            MaterialInventorySummaryVO saveOrUpdateVO = (MaterialInventorySummaryVO)((Object)BeanMapper.map((Object)((Object)materialInventorySummaryEntity), MaterialInventorySummaryVO.class));
            if (materialInventorySummaryEntity.getId() == null || materialInventorySummaryEntity.getId() == 0L) {
                BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
                CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
                if (billCode.isSuccess()) {
                    materialInventorySummaryEntity.setBillCode((String)billCode.getData());
                } else {
                    throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c\u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5");
                }
            }
            this.materialInventorySummaryService.save((Object)materialInventorySummaryEntity);
        }
    }
}

