package com.ejianc.business.cost.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

/**
 * 骨料6投放明细
 * 
 * @author generator
 * 
 */
 @TableName("ejc_aggregate6_detail")
public class Aggregate6DetailEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="bill_code")
    private String billCode; // 单据编号
    @TableField(value="mid")
    private Long mid; // 主表id主键
    @TableField(value="material_id")
    private Long materialId; // 原材料id
    @TableField(value="material_name")
    private String materialName; // 原材料名称
    @TableField(value="material_throw_percent")
    private BigDecimal materialThrowPercent; // 原材料投放比例
    @TableField(value="bill_state")
    private Integer billState; // 单据状态: 0自由态,1已提交,2审批中,3审批通过,4驳回,5提交后有人审批中
    @TableField(value="material_varieties_id")
    private Long materialVarietiesId; // 原材料核算品种名称
    @TableField(value="material_varieties_name")
    private String materialVarietiesName; // 原材料核算品种名称
    
    

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Long getMid() {
        return mid;
    }

    public void setMid(Long mid) {
        this.mid = mid;
    }
    public Long getMaterialId() {
        return materialId;
    }

    public void setMaterialId(Long materialId) {
        this.materialId = materialId;
    }
    public String getMaterialName() {
        return materialName;
    }

    public void setMaterialName(String materialName) {
        this.materialName = materialName;
    }
    public BigDecimal getMaterialThrowPercent() {
        return materialThrowPercent;
    }

    public void setMaterialThrowPercent(BigDecimal materialThrowPercent) {
        this.materialThrowPercent = materialThrowPercent;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public Long getMaterialVarietiesId() {
        return materialVarietiesId;
    }

    public void setMaterialVarietiesId(Long materialVarietiesId) {
        this.materialVarietiesId = materialVarietiesId;
    }

    public String getMaterialVarietiesName() {
        return materialVarietiesName;
    }

    public void setMaterialVarietiesName(String materialVarietiesName) {
        this.materialVarietiesName = materialVarietiesName;
    }
}
