package com.ejianc.business.cost.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

/**
 * 盘点汇总表
 * 
 * @author generator
 * 
 */
 @TableName("ejc_production_material_inventory_summary")
public class MaterialInventorySummaryEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="bill_code")
    private String billCode; // 单据编号
    @TableField(value="material_id")
    private Long materialId; //原材料id
    @TableField(value="material_name")
    private String materialName; // 原材料名称
    @TableField(value="material_varieties_id")
    private Long materialVarietiesId; // 原材料品种id
    @TableField(value="material_varieties_name")
    private String materialVarietiesName; // 原材料品种名称
    @TableField(value="inventory_date")
    private Date inventoryDate; // 盘点日期
    @TableField(value="inventory_quantity")
    private BigDecimal inventoryQuantity; // 盘点数量
    @TableField(value="inventory_account")
    private BigDecimal inventoryAccount; // 盘点金额
    @TableField(value="current_quantity")
    private BigDecimal currentQuantity; // 当前账面数量
    @TableField(value="current_amount")
    private BigDecimal currentAmount; // 当前账面金额
    @TableField(value="price")
    private BigDecimal price; // 单价
    @TableField(value="profit_loss_quantity")
    private BigDecimal profitLossQuantity; // 盈亏数量
    @TableField(value="profit_loss_amount")
    private BigDecimal profitLossAmount; // 盈亏金额
    @TableField(value="org_id")
    private Long orgId; // 组织id
    @TableField(value="org_name")
    private String orgName; // 组织名称
    @TableField(value="remark")
    private String remark; // 备注
    @TableField(value="bill_state")
    private Integer billState; // 单据状态: 0自由态,1已提交,2审批中,3审批通过,4驳回,5提交后有人审批中
    
    
    

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Long getMaterialVarietiesId() {
        return materialVarietiesId;
    }

    public void setMaterialVarietiesId(Long materialVarietiesId) {
        this.materialVarietiesId = materialVarietiesId;
    }
    public String getMaterialVarietiesName() {
        return materialVarietiesName;
    }

    public void setMaterialVarietiesName(String materialVarietiesName) {
        this.materialVarietiesName = materialVarietiesName;
    }
    public BigDecimal getInventoryQuantity() {
        return inventoryQuantity;
    }

    public void setInventoryQuantity(BigDecimal inventoryQuantity) {
        this.inventoryQuantity = inventoryQuantity;
    }
    public BigDecimal getInventoryAccount() {
        return inventoryAccount;
    }

    public void setInventoryAccount(BigDecimal inventoryAccount) {
        this.inventoryAccount = inventoryAccount;
    }
    public BigDecimal getCurrentQuantity() {
        return currentQuantity;
    }

    public void setCurrentQuantity(BigDecimal currentQuantity) {
        this.currentQuantity = currentQuantity;
    }
    public BigDecimal getCurrentAmount() {
        return currentAmount;
    }

    public void setCurrentAmount(BigDecimal currentAmount) {
        this.currentAmount = currentAmount;
    }
    public BigDecimal getPrice() {
        return price;
    }

    public void setPrice(BigDecimal price) {
        this.price = price;
    }
    public BigDecimal getProfitLossQuantity() {
        return profitLossQuantity;
    }

    public void setProfitLossQuantity(BigDecimal profitLossQuantity) {
        this.profitLossQuantity = profitLossQuantity;
    }
    public BigDecimal getProfitLossAmount() {
        return profitLossAmount;
    }

    public void setProfitLossAmount(BigDecimal profitLossAmount) {
        this.profitLossAmount = profitLossAmount;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }

    public Long getMaterialId() {
        return materialId;
    }

    public void setMaterialId(Long materialId) {
        this.materialId = materialId;
    }

    public String getMaterialName() {
        return materialName;
    }

    public void setMaterialName(String materialName) {
        this.materialName = materialName;
    }

    public Date getInventoryDate() {
        return inventoryDate;
    }

    public void setInventoryDate(Date inventoryDate) {
        this.inventoryDate = inventoryDate;
    }
}
