package com.ejianc.business.cost.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

/**
 * 原材料耗用表
 * 
 * @author generator
 * 
 */
 @TableName("ejc_production_material_use")
public class MaterialUseEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="bill_code")
    private String billCode; // 单据编号
    @TableField(value="product_id")
    private Long productId; // 产品id
    @TableField(value="product_name")
    private String productName; // 产品名称
    @TableField(value="product_time")
    private Date productTime; // 发货日期
    @TableField(value="production_mixture_name")
    private String productionMixtureName; // 生产配比名称
    @TableField(value="production_mixture_id")
    private Long productionMixtureId; // 生产配比id
    @TableField(value="net_weight_sum")
    private BigDecimal netWeightSum; //发货数总和
    @TableField(value="org_id")
    private Long orgId; // 所属组织id
    @TableField(value="org_name")
    private String orgName; // 所属组织名称
    @TableField(value="bill_state")
    private Integer billState; // 单据状态: 0自由态,1已提交,2审批中,3审批通过,4驳回,5提交后有人审批中


    @TableField(exist=false)
    @SubEntity(serviceName="materialUseDetailService",pidName = "mid")//此处有pid="xxx"，默认值pid="pid"
    List<MaterialUseDetailEntity> materialUseEntities = new ArrayList<>();
    

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Long getProductId() {
        return productId;
    }

    public void setProductId(Long productId) {
        this.productId = productId;
    }
    public String getProductName() {
        return productName;
    }

    public void setProductName(String productName) {
        this.productName = productName;
    }
    public Date getProductTime() {
        return productTime;
    }

    public void setProductTime(Date productTime) {
        this.productTime = productTime;
    }
    public String getProductionMixtureName() {
        return productionMixtureName;
    }

    public void setProductionMixtureName(String productionMixtureName) {
        this.productionMixtureName = productionMixtureName;
    }
    public Long getProductionMixtureId() {
        return productionMixtureId;
    }

    public void setProductionMixtureId(Long productionMixtureId) {
        this.productionMixtureId = productionMixtureId;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }

    public List<MaterialUseDetailEntity> getMaterialUseEntities() {
        return materialUseEntities;
    }

    public void setMaterialUseEntities(List<MaterialUseDetailEntity> materialUseEntities) {
        this.materialUseEntities = materialUseEntities;
    }

    public BigDecimal getNetWeightSum() {
        return netWeightSum;
    }

    public void setNetWeightSum(BigDecimal netWeightSum) {
        this.netWeightSum = netWeightSum;
    }
}
