package com.ejianc.business.cost.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

import com.ejianc.business.cost.bean.Aggregate7DetailEntity;
/**
 * 成本结算
 * 
 * @author generator
 * 
 */
 @TableName("ejc_settlement_period")
public class SettlementPeriodEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="year")
    private String year; // 年度
    @TableField(value="org_id")
    private Long orgId; // 所属组织id
    @TableField(value="bill_state")
    private Integer billState; // 单据状态: 0自由态,1已提交,2审批中,3审批通过,4驳回,5提交后有人审批中
    @TableField(value="org_name")
    private String orgName; // 组织名称
    
    
    @TableField(exist=false)
    @SubEntity(serviceName="settlementPeriodDetailService",pidName = "mid")
    private List<SettlementPeriodDetailEntity> settlementPeriodEntities = new ArrayList<>(); // 成本结算子表
    

    public String getYear() {
        return year;
    }

    public void setYear(String year) {
        this.year = year;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    public List<SettlementPeriodDetailEntity> getSettlementPeriodEntities() {
        return settlementPeriodEntities;
    }

    public void setSettlementPeriodEntities(List<SettlementPeriodDetailEntity> settlementPeriodEntities) {
        this.settlementPeriodEntities = settlementPeriodEntities;
    }
}
