package com.ejianc.business.cost.controller;

import java.io.Serializable;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.cost.bean.*;
import com.ejianc.business.cost.service.*;
import com.ejianc.business.cost.vo.*;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.*;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.*;
import org.apache.commons.collections.CollectionUtils;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

/**
 * 成本结算
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("settlementPeriod")
public class SettlementPeriodController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "Invoice_Open_Apply_Code";//此处需要根据实际修改

    @Autowired
    private ISettlementPeriodService service;
    @Autowired
    private ISettlementPeriodDetailService settlementPeriodDetailService;
    @Autowired
    private IMaterialDynamicInService materialDynamicInService;
    @Autowired
    private IMaterialDynamicOutService materialDynamicOutService;
    @Autowired
    private IMaterialUseService materialUseService;
    @Autowired
    private IDatasummaryService datasummaryService;
    @Autowired
    private SessionManager sessionManager;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<SettlementPeriodVO> saveOrUpdate(@RequestBody SettlementPeriodVO saveOrUpdateVO) {
    	SettlementPeriodEntity entity = BeanMapper.map(saveOrUpdateVO, SettlementPeriodEntity.class);
    	if (entity.getId() == null){
            for (SettlementPeriodDetailEntity settlementPeriodEntity : entity.getSettlementPeriodEntities()) {
                settlementPeriodEntity.setIsCalculate(0);
            }
        }
    	service.saveOrUpdate(entity, false);
    	SettlementPeriodVO vo = BeanMapper.map(entity, SettlementPeriodVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<SettlementPeriodVO> queryDetail(Long id) {
    	SettlementPeriodEntity entity = service.selectById(id);
    	SettlementPeriodVO vo = BeanMapper.map(entity, SettlementPeriodVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<SettlementPeriodVO> vos) {
        if(ListUtil.isNotEmpty(vos)){
            for (SettlementPeriodVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
            }
        }
        service.removeByIds(vos.stream().map(SettlementPeriodVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<SettlementPeriodVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
        UserContext userContextCache =sessionManager.getUserContext();
        //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
        String authOrgIds = userContextCache.getAuthOrgIds();
        List<OrgVO> orgVOList = null;
        if(StringUtils.isNotBlank(authOrgIds)){//移动端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
        }else {//pc端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
        }
        //普通组织 id
        List<Long> commonOrgIds = new ArrayList<>();
        //项目部 id
        List<Long> departmentIds = new ArrayList<>();
        orgVOList.stream().forEach(org -> {
            if(5 == org.getOrgType()) {
                //项目部
                departmentIds.add(org.getId());
            } else {
                //普通组织
                commonOrgIds.add(org.getId());
            }
        });
        if(CollectionUtils.isNotEmpty(commonOrgIds)) {
            /** 要求主表有orgId字段，保存单据所属组织 */
            param.getParams().put("orgId", new Parameter(QueryParam.IN, commonOrgIds));
        } else if(CollectionUtils.isNotEmpty(departmentIds)) {
            /** 要求主表有projectDepartmentId字段，保存单据所属项目部 */
            param.getParams().put("projectDepartmentId", new Parameter(QueryParam.IN, departmentIds));
        }
        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */

        IPage<SettlementPeriodEntity> page = service.queryPage(param,false);
        IPage<SettlementPeriodVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), SettlementPeriodVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<SettlementPeriodEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("SettlementPeriod-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @param
     * @Return void
     */
    @RequestMapping(value = "/refSettlementPeriodData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<SettlementPeriodVO>> refSettlementPeriodData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<SettlementPeriodEntity> page = service.queryPage(param,false);
        IPage<SettlementPeriodVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), SettlementPeriodVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }

    /**
     * 结算成本
     * @param id 结算成本子表id
     * @return
     */
    @Transactional
    @RequestMapping(value = "/settlementcost", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<SettlementPeriodVO> settlementCost(@RequestParam Long id){
        SettlementPeriodDetailEntity entity = settlementPeriodDetailService.selectById(id);
        /**
         * 此处为成本结算生成材料动态表数据业务逻辑
         */
        //获取会话用户组织id
        Long orgId = sessionManager.getUserContext().getOrgId();
        materialDynamicInService.calculateMaterialDynamicIn(entity.getStartDate(),entity.getEndDate(),orgId);
        entity.setIsCalculate(1);
        settlementPeriodDetailService.updateById(entity);
        SettlementPeriodEntity settlementPeriodEntity = service.selectById(entity.getMid());
        SettlementPeriodVO map = BeanMapper.map(settlementPeriodEntity, SettlementPeriodVO.class);
        return CommonResponse.success("成本结算成功",map);
    }
    /**
     * 取消结算成本
     * @param id 结算成本子表id
     * @return
     */
    @Transactional
    @RequestMapping(value = "/canclesettlementcost", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<SettlementPeriodVO> cancleSettlementCost(@RequestParam Long id){
        SettlementPeriodDetailEntity entity = settlementPeriodDetailService.selectById(id);
        /**
         * 此处为取消成本结算删除材料动态表数据业务逻辑
         */
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.ge("date",entity.getStartDate());
        queryWrapper.le("date",entity.getEndDate());
        List<MaterialDynamicInEntity> list = materialDynamicInService.list(queryWrapper);
        if (!list.isEmpty()){
            List<MaterialDynamicInVO> vos = BeanMapper.mapList(list, MaterialDynamicInVO.class);
            materialDynamicInService.removeByIds(vos.stream().map(MaterialDynamicInVO :: getId).collect(Collectors.toList()),true);
        }
        entity.setIsCalculate(0);
        settlementPeriodDetailService.updateById(entity);
        SettlementPeriodEntity settlementPeriodEntity = service.selectById(entity.getMid());
        SettlementPeriodVO map = BeanMapper.map(settlementPeriodEntity, SettlementPeriodVO.class);
        return CommonResponse.success("取消成本结算成功",map);
    }

    /**
     * 计算发货标准原材料耗用量
     * @param id 结算成本子表id
     * @return
     */
    @Transactional
    @RequestMapping(value = "/calculateShip", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<SettlementPeriodVO> calculateShip(@RequestParam Long id){
        SettlementPeriodDetailEntity entity = settlementPeriodDetailService.selectById(id);
        /**
         * 此处为计算发货原材料耗用量生成原材料标准耗用量数据业务逻辑
         */
        materialUseService.calculateMaterialUse(entity.getStartDate(),entity.getEndDate());
        entity.setIsCalculateShip(1);
        settlementPeriodDetailService.updateById(entity);
        SettlementPeriodEntity settlementPeriodEntity = service.selectById(entity.getMid());
        SettlementPeriodVO map = BeanMapper.map(settlementPeriodEntity, SettlementPeriodVO.class);
        return CommonResponse.success("计算标准耗用成功",map);
    }
    /**
     * 取消计算发货标准耗用量
     * @param id 结算成本子表id
     * @return
     */
    @Transactional
    @RequestMapping(value = "/cancleCalculateShip", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<SettlementPeriodVO> cancleCalculateShip(@RequestParam Long id){
        SettlementPeriodDetailEntity detailEntity = settlementPeriodDetailService.selectById(id);
        /**
         * 此处为取消成本结算删除材料动态表数据业务逻辑
         */
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.ge("product_time",detailEntity.getStartDate());
        queryWrapper.le("product_time",detailEntity.getEndDate());
        List<MaterialUseEntity> list = materialUseService.list(queryWrapper);
        List<MaterialUseEntity> materialUseEntities = new ArrayList<>();
        if (!list.isEmpty()){
            for (MaterialUseEntity materialUseEntity : list) {
                MaterialUseEntity entity = materialUseService.selectById(materialUseEntity.getId());
                materialUseEntities.add(entity);
            }
            List<MaterialUseVO> vos = BeanMapper.mapList(materialUseEntities, MaterialUseVO.class);
            materialUseService.removeByIds(vos.stream().map(MaterialUseVO :: getId).collect(Collectors.toList()),true);
        }
        detailEntity.setIsCalculateShip(0);
        settlementPeriodDetailService.updateById(detailEntity);
        SettlementPeriodEntity settlementPeriodEntity = service.selectById(detailEntity.getMid());
        SettlementPeriodVO map = BeanMapper.map(settlementPeriodEntity, SettlementPeriodVO.class);
        return CommonResponse.success("取消计算标准耗用成功",map);
    }
    /**
     * 计算对外材料耗用表
     * @param id 结算成本子表id
     * @return
     */
    @Transactional
    @RequestMapping(value = "/calculateCost", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<SettlementPeriodVO> calculateCost(@RequestParam Long id){
        SettlementPeriodDetailEntity entity = settlementPeriodDetailService.selectById(id);
        /**
         * 此处为计算发货原材料耗用量生成原材料标准耗用量数据业务逻辑
         */
        //获取会话用户组织id
        Long orgId = sessionManager.getUserContext().getOrgId();
        materialDynamicOutService.calculateMaterialDynamicOut(entity.getStartDate(),entity.getEndDate(),orgId);
        entity.setIsCalculateCost(1);
        settlementPeriodDetailService.updateById(entity);
        SettlementPeriodEntity settlementPeriodEntity = service.selectById(entity.getMid());
        SettlementPeriodVO map = BeanMapper.map(settlementPeriodEntity, SettlementPeriodVO.class);
        return CommonResponse.success("计算标准成本成功",map);
    }
    /**
     * 取消计算对外材料动态表
     * @param id 结算成本子表id
     * @return
     */
    @Transactional
    @RequestMapping(value = "/cancleCalculateCost", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<SettlementPeriodVO> cancleCalculateCost(@RequestParam Long id){
        SettlementPeriodDetailEntity detailEntity = settlementPeriodDetailService.selectById(id);
        /**
         * 此处为取消成本结算删除材料动态表数据业务逻辑
         */
        QueryWrapper<MaterialDynamicOutEntity> queryWrapper = new QueryWrapper();
        queryWrapper.ge("date",detailEntity.getStartDate());
        queryWrapper.le("date",detailEntity.getEndDate());
        List<MaterialDynamicOutEntity> list = materialDynamicOutService.list(queryWrapper);
        if (!list.isEmpty()){
            List<MaterialDynamicOutVO> vos = BeanMapper.mapList(list, MaterialDynamicOutVO.class);
            materialDynamicOutService.removeByIds(vos.stream().map(MaterialDynamicOutVO :: getId).collect(Collectors.toList()),true);
        }
        detailEntity.setIsCalculateCost(0);
        settlementPeriodDetailService.updateById(detailEntity);
        SettlementPeriodEntity settlementPeriodEntity = service.selectById(detailEntity.getMid());
        SettlementPeriodVO map = BeanMapper.map(settlementPeriodEntity, SettlementPeriodVO.class);
        return CommonResponse.success("取消计算标准成本成功",map);
    }

    /**
     * 计算生产数据原材料用量
     * @param id 结算成本子表id
     * @return
     */
    @Transactional
    @RequestMapping(value = "/calculateProduction", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<SettlementPeriodVO> calculateProduction(@RequestParam Long id){
        SettlementPeriodDetailEntity entity = settlementPeriodDetailService.selectById(id);
        /**
         * 此处为计算发货原材料耗用量生成原材料标准耗用量数据业务逻辑
         */
        //获取会话用户组织id
        Long orgId = sessionManager.getUserContext().getOrgId();
        datasummaryService.calProductionData(entity.getStartDate(),entity.getEndDate(),orgId);
        entity.setIsCalculateProduction(1);
        settlementPeriodDetailService.updateById(entity);
        SettlementPeriodEntity settlementPeriodEntity = service.selectById(entity.getMid());
        SettlementPeriodVO map = BeanMapper.map(settlementPeriodEntity, SettlementPeriodVO.class);
        return CommonResponse.success("计算原材料耗用成功",map);
    }
    /**
     * 取消计算对外材料动态表
     * @param id 结算成本子表id
     * @return
     */
    @Transactional
    @RequestMapping(value = "/cancleCalculateProduction", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<SettlementPeriodVO> cancleCalculateProduction(@RequestParam Long id){
        SettlementPeriodDetailEntity detailEntity = settlementPeriodDetailService.selectById(id);
        /**
         * 此处为取消成本结算删除材料动态表数据业务逻辑
         */
        QueryWrapper<DatasummaryEntity> queryWrapper = new QueryWrapper();
        queryWrapper.between("product_time",detailEntity.getStartDate(),detailEntity.getEndDate());
        List<DatasummaryEntity> list = datasummaryService.list(queryWrapper);
        List<DatasummaryEntity> entities = new ArrayList<>();
        if (!list.isEmpty()){
            list.forEach(element -> {
                DatasummaryEntity datasummaryEntity = datasummaryService.selectById(element.getId());
                entities.add(datasummaryEntity);
            });
            List<DatasummaryVO> vos = BeanMapper.mapList(entities, DatasummaryVO.class);
            datasummaryService.removeByIds(vos.stream().map(DatasummaryVO :: getId).collect(Collectors.toList()),true);
        }
        detailEntity.setIsCalculateProduction(0);
        settlementPeriodDetailService.updateById(detailEntity);
        SettlementPeriodEntity settlementPeriodEntity = service.selectById(detailEntity.getMid());
        SettlementPeriodVO map = BeanMapper.map(settlementPeriodEntity, SettlementPeriodVO.class);
        return CommonResponse.success("取消计算原材料耗用成功",map);
    }
}
