package com.ejianc.business.cost.controller.api;

import com.ejianc.business.cost.bean.DatatotalEntity;
import com.ejianc.business.cost.bean.GasAndElectricEntity;
import com.ejianc.business.cost.service.*;
import com.ejianc.business.cost.vo.DatatotalVO;
import com.ejianc.business.openapi.cost.vo.GasAndElectricVO;
import com.ejianc.business.openapi.cost.vo.ProductDataVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.*;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;


/**
 * @authoer:禹鹏杰
 * @createDate:2022/7/30
 * @description:同步生产数据插入mysql接口
 */
@RestController
@RequestMapping("/api/cost/synchronizedataApi")
public class SynchronizeDataApi {
    
    @Autowired
    private IDatatotalService service;
    @Autowired
    private IGasAndElectricService gasAndElectricService;
    @Autowired
    private IBillCodeApi billCodeApi;

    private static final String BILL_CODE = "Invoice_Open_Apply_Code";//此处需要根据实际修改


    /**
     * @Description saveOrUpdate 同步生产数据
     * 同步生产数据完生成原材料的本期消耗数量
     * 查询本期的原材料的分组汇总消耗数
     * 循环每个原材料对应找到原材料的购入数据计算原材料的本期消耗数据
     */
    @RequestMapping(value = "/synchronizedata", method = RequestMethod.POST)
    @ResponseBody
    @Transactional
    public CommonResponse synchronizeData(@RequestBody List<ProductDataVO> productDataVOS){
        SimpleDateFormat sf = new SimpleDateFormat("yyyy-MM-dd");
        //同步生成生产数据
        List<DatatotalEntity> datatotalEntities = BeanMapper.mapList(productDataVOS, DatatotalEntity.class);
        datatotalEntities.forEach(element->{
            DatatotalVO saveOrUpdateVO = BeanMapper.map(element, DatatotalVO.class);
            if(element.getId() == null || element.getId() == 0){
                BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE,InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
                CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
                if(billCode.isSuccess()) {
                    element.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
                }else{
                    throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
                }
                element.setTotalDate(new Date());
            }
        });
        service.saveBatch(datatotalEntities);
        return  CommonResponse.success("同步生产数据成功");
    }
    /**
     * @Description saveOrUpdate 同步燃气电量用量数据
     */
    @RequestMapping(value = "/synchronizegasdata", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse synchronizeGasData(@RequestBody GasAndElectricVO saveOrUpdateVO){
        GasAndElectricEntity entity = BeanMapper.map(saveOrUpdateVO, GasAndElectricEntity.class);
        if(entity.getId() == null || entity.getId() == 0){
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE, InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        gasAndElectricService.save(entity);
        return CommonResponse.success("同步燃气数据成功");
    }
}
