package com.ejianc.business.cost.excel;

import cn.hutool.poi.excel.ExcelUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.base.bases.api.BaseSelectApi;
import com.ejianc.business.base.bases.vo.MaterialVO;
import com.ejianc.business.cost.bean.MaterialInventoryRecordEntity;
import com.ejianc.business.cost.service.IMaterialInventoryRecordService;
import com.ejianc.business.cost.vo.MaterialInventoryRecordVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.core.util.ImportTemplate;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.ParseException;
import java.util.*;

/**
 * @authoer:禹鹏杰
 * @createDate:2022/10/13
 * @description: 材料盘点导入
 */
@Controller
@RequestMapping("mateiralInventoryRecordExcel")
public class ExcelMateiralInventoryRecordController implements Serializable {
    private static final long serialVersionUID = 1L;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Qualifier("com.ejianc.business.base.bases.api.BaseSelectApi")
    @Autowired
    private BaseSelectApi baseSelectApi;
    @Autowired
    private IMaterialInventoryRecordService service;

    private static final String BILL_CODE = "Invoice_Open_Apply_Code";//此处需要根据实际修改
    @Autowired
    private SessionManager sessionManager;
    /**
     * 导入模板下载
     *
     * @param request
     * @param response
     */
    @RequestMapping(value = "/downloadImportModal")
    @ResponseBody
    public void downloadMaterialrequirement(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize(response);
        ImportTemplate.templetdownload(request, "MaterialInventoryRecord-import.xlsx", "材料盘点档案导入模板");
    }

    /**
     * excel导入
     * @param request
     * @param response
     * @return
     */
    @RequestMapping(value = "/importByModal", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<Object> importByModal(HttpServletRequest request, HttpServletResponse response) throws ParseException {
        Long orgId = sessionManager.getUserContext().getOrgId();
        String userCode = sessionManager.getUserContext().getUserCode();
        MaterialVO materialVO = null;
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
        Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();
        List<MaterialInventoryRecordVO> successList = new ArrayList<>();
        List<MaterialInventoryRecordVO> errorList = new ArrayList<>();
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry<String, MultipartFile> entity : fileMap.entrySet()) {
            mf = entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt(originalFileName, false);
            if (!"xls".equals(extName) && !"xlsx".equals(extName)) {
                isFailed = true;
                break;
            }
        }
        if (isFailed) {
            return CommonResponse.error("文件格式不合法");
        } else {
            List<List<String>> result = ExcelReader.readExcel(mf);
            if ( result.size() > 0) {
                for (int i = 1; i < result.size(); i++) {
                    List<String> data = result.get(i);
                    MaterialInventoryRecordVO VO = new MaterialInventoryRecordVO();
                    VO.setId(IdWorker.getId());
                    VO.setMaterialName(StringUtils.isNotBlank(data.get(0)) ? data.get(0) : null);
                    VO.setCategoryName(StringUtils.isNotBlank(data.get(1)) ? data.get(1) : null);
                    VO.setMaterialVarietiesName(StringUtils.isNotBlank(data.get(2)) ? data.get(2) : null);
                    VO.setPosition(StringUtils.isNotBlank(data.get(3)) ? data.get(3) : null);
                    VO.setLength(StringUtils.isNotBlank(data.get(4)) ? new BigDecimal(data.get(4)) : BigDecimal.ZERO);
                    VO.setWidth(StringUtils.isNotBlank(data.get(5)) ? new BigDecimal(data.get(5)) : BigDecimal.ZERO);
                    VO.setDensity(StringUtils.isNotBlank(data.get(6)) ? new BigDecimal(data.get(6)) : BigDecimal.ZERO);
                    VO.setOrgId(orgId);
                    VO.setCreateUserCode(userCode);
                    if (StringUtils.isEmpty(data.get(0)) || data.get(0) == null) {
                        VO.setErrorMsg("'原材料名称'不能为空！");
                        errorList.add(VO);
                        continue;
                    }else{
                        QueryWrapper query=new QueryWrapper();
                        query.eq("material_name",data.get(0));
                        query.eq("org_id",orgId);
                        MaterialInventoryRecordEntity entity = service.getOne(query);
                        if (entity !=null){
                            VO.setErrorMsg("查重校验:"+data.get(0)+"原材料盘点档案已存在");
                            errorList.add(VO);
                            continue;
                        }else {
                            materialVO = baseSelectApi.queryMaterialByName(data.get(0), orgId);
                            if (materialVO == null || materialVO.getId() == null || materialVO.getId() == 0){
                                VO.setErrorMsg("原材料库未查找到此原材料，请检查原材料库");
                                errorList.add(VO);
                                continue;
                            }else {
                                VO.setMaterialId(materialVO.getId());
                                VO.setCategoryId(materialVO.getCategoryId());
                                VO.setCategoryName(materialVO.getCategoryName());
                                VO.setMaterialVarietiesId(materialVO.getVarietiesId());
                                VO.setMaterialVarietiesName(materialVO.getVarietiesName());
                            }
                        }
                    }
                    if (StringUtils.isEmpty(data.get(3)) || data.get(1) == null) {
                        VO.setErrorMsg("'库位'不能为空！");
                        errorList.add(VO);
                        continue;
                    }
                    if (StringUtils.isEmpty(data.get(4)) || data.get(1) == null) {
                        VO.setErrorMsg("'长'不能为空！");
                        errorList.add(VO);
                        continue;
                    }
                    if (StringUtils.isEmpty(data.get(5)) || data.get(1) == null) {
                        VO.setErrorMsg("'宽'不能为空！");
                        errorList.add(VO);
                        continue;
                    }
                    if (StringUtils.isEmpty(data.get(6)) || data.get(1) == null) {
                        VO.setErrorMsg("'密度'不能为空！");
                        errorList.add(VO);
                        continue;
                    }
                    successList.add(VO);
                }
                if (errorList.size() == 0) {
                    List<MaterialInventoryRecordEntity> entities = BeanMapper.mapList(successList, MaterialInventoryRecordEntity.class);
                    for (MaterialInventoryRecordEntity entity : entities) {
                        MaterialInventoryRecordVO VO = BeanMapper.map(entity, MaterialInventoryRecordVO.class);
                        BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE, InvocationInfoProxy.getTenantid(),VO);
                        CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
                        if(billCode.isSuccess()) {
                            entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者下一行
                        }
                    }
                    service.saveBatch(entities, entities.size());
                }
            }
        }
        JSONObject json = new JSONObject();
        json.put("successNum", successList.size());
        json.put("successList", successList);
        json.put("errorList", errorList);
        json.put("errorNum", errorList.size());
        return CommonResponse.success(json);
    }

}
