package com.ejianc.business.cost.service;

import com.ejianc.business.cost.vo.MaterialUseTotalVO;
import com.ejianc.business.openapi.cost.vo.ProductDataVO;
import com.ejianc.framework.skeleton.template.IBaseService;
import com.ejianc.business.cost.bean.DatasummaryEntity;

import java.util.Date;
import java.util.List;

/**
 * 数据汇总
 * 
 * @author generator
 * 
 */
public interface IDatasummaryService extends IBaseService<DatasummaryEntity> {

    /**
     * 按原材料和日期分组汇总消耗总量
     * @param productTime   生产时间
     * @param materialId    原材料id
     * @return
     */
    MaterialUseTotalVO queryMaterialUseTotal(String productTime,String materialId);

    /**
     *
     * @param startDate 开始时间
     * @param endDate  结束时间
     * @param orgId   组织id
     */
    void calProductionData(Date startDate, Date endDate, Long orgId);
}
