package com.ejianc.business.cost.service;

import com.ejianc.framework.skeleton.template.IBaseService;
import com.ejianc.business.cost.bean.MaterialBuyEntity;

import java.util.Date;

/**
 * 本期购入数量
 * 
 * @author generator
 * 
 */
public interface IMaterialBuyService extends IBaseService<MaterialBuyEntity> {
    /**
     * 生成原材料的本期购入数据
     * @param productTime 生产日期
     * @param orgId 组织id
     */
    void generateMaterialBuy(String productTime,String orgId);

    /**
     * 获取原材料当前日期的购入数量
     * @param materialId 原材料id
     * @param date       查询日期条件
     * @return           原材料本期购入实体
     */
    MaterialBuyEntity getCurrentDateMaterialBuyEntity(Long materialId, Date date,Long orgId);
}
