package com.ejianc.business.cost.service;

import com.ejianc.business.cost.vo.MaterialInventorySummaryVO;
import com.ejianc.business.cost.vo.MaterialInventoryVO;
import com.ejianc.framework.skeleton.template.IBaseService;
import com.ejianc.business.cost.bean.MaterialChangeEntity;

import java.util.Date;
import java.util.List;

/**
 * 本期调整数量
 * 
 * @author generator
 * 
 */
public interface IMaterialChangeService extends IBaseService<MaterialChangeEntity> {
    /**
     * 生成本期调整数量
     * @param materialInventorySummaryVO 材料盘点汇总VO
     */
    void saveMaterialChangeEntity(MaterialInventorySummaryVO materialInventorySummaryVO);

    /**
     * 查询当前日期本期调整数据
     * @param materialId 原材料id
     * @param date       当前日期查询条件
     * @return          本期调整实体
     */
    MaterialChangeEntity getCurrentDateMaterialChangeEntity(Long materialId, Date date);

    void saveBatchMaterialChange(List<MaterialInventorySummaryVO> materialInventorySummaryVOS);
}
