package com.ejianc.business.cost.service;


import com.ejianc.business.cost.bean.MaterialDynamicInEntity;
import com.ejianc.business.cost.bean.MaterialDynamicOutEntity;
import com.ejianc.business.purchasingmanagement.vo.AcceptanceVO;
import com.ejianc.framework.skeleton.template.IBaseService;
import com.ejianc.business.cost.bean.MaterialConsumeEntity;

import java.math.BigDecimal;
import java.util.Date;
import java.util.Map;

/**
 * 本期消耗数量
 * 
 * @author generator
 * 
 */
public interface IMaterialConsumeService extends IBaseService<MaterialConsumeEntity> {
    /**
     * 生成原材料的本期耗用量
     * @param productTime 生产日期
     * @param orgId 组织id
     */
    void generateMaterialConsume(String productTime,String orgId);

    /**
     * 获取生产数据按原材料，日期分组汇总的消耗数量
     * @param materialId  原材料id
     * @param date        日期
     * @param orgId       组织id
     * @return
     */
    MaterialConsumeEntity getCurrentDateMaterialConsumeEntity(Long materialId, Date date, Long orgId, Map<String, MaterialDynamicInEntity> map);
    /**
     * 获取标准原材料耗用数据按原材料，日期分组汇总的消耗数量
     * @param materialId  原材料id
     * @param date        日期
     * @param orgId       组织id
     * @return
     */
    MaterialConsumeEntity getCurrentDateStandardMaterialConsumeEntity(Long materialId, Date date, Long orgId, Map<String, MaterialDynamicOutEntity> map);

    /**
     * 计算加权平均单价
     * @param materialId  原材料id
     * @param map 存放原材料对应的原材料生产动态表
     * @param data 查询到的本期购入的数据
     * @return
     */
    BigDecimal calWeightedAverageUnitPrice(Long materialId, Map<String, MaterialDynamicInEntity> map, AcceptanceVO data);
    /**
     * 计算对外加权平均单价
     * @param materialId  原材料id
     * @param map 存放原材料对应的原材料生产动态表
     * @param data 查询到的本期购入的数据
     * @return
     */
    BigDecimal calOutWeightedAverageUnitPrice(Long materialId, Map<String, MaterialDynamicOutEntity> map, AcceptanceVO data);

}
