package com.ejianc.business.cost.service;

import com.ejianc.business.cost.vo.MaterialDynamicInVO;
import com.ejianc.framework.skeleton.template.IBaseService;
import com.ejianc.business.cost.bean.MaterialDynamicInEntity;

import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * 材料摊销动态表(对内)
 * 
 * @author generator
 * 
 */
public interface IMaterialDynamicInService extends IBaseService<MaterialDynamicInEntity> {
    /**
     * 成本结算
     * @param startDate 开始时间
     * @param endDate  结束时间
     */
    void calculateMaterialDynamicIn(Date startDate,Date endDate,Long orgId);

    /**
     * 查询当前日期前一天的材料动态表数据
     * @param materialId
     * @param
     * @return
     */
    MaterialDynamicInEntity getOneDayAgoEntity(Long materialId, Map<String,MaterialDynamicInEntity> map);

    /**
     * 汇总材料动态表
     * @param  map 查询参数
     * @return
     */
    List<MaterialDynamicInVO> materialDynamicInTotal(Map<String,Object> map);
}
