package com.ejianc.business.cost.service;

import com.ejianc.business.cost.bean.MaterialDynamicInEntity;
import com.ejianc.business.cost.vo.MaterialDynamicInVO;
import com.ejianc.business.cost.vo.MaterialDynamicOutVO;
import com.ejianc.framework.skeleton.template.IBaseService;
import com.ejianc.business.cost.bean.MaterialDynamicOutEntity;

import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * 材料摊销动态表(对外)
 * 
 * @author generator
 * 
 */
public interface IMaterialDynamicOutService extends IBaseService<MaterialDynamicOutEntity> {
    /**
     * 成本结算
     * @param startDate 开始时间
     * @param endDate  结束时间
     */
    void calculateMaterialDynamicOut(Date startDate, Date endDate, Long orgId);

    /**
     * 查询当前日期前一天的材料动态表数据
     * @param materialId 原材料id
     * @param map    原材料id对应的上一次的动态表
     * @return
     */
    MaterialDynamicOutEntity getOneDayAgoEntity(Long materialId, Map<String,MaterialDynamicOutEntity> map);
    /**
     * 汇总材料动态表
     * @param map  组织id
     * @return
     */
    List<MaterialDynamicOutVO> materialDynamicOutTotal(Map<String,Object> map);
}
