package com.ejianc.business.cost.service;

import com.ejianc.business.cost.vo.MaterialUseTotalVO;
import com.ejianc.framework.skeleton.template.IBaseService;
import com.ejianc.business.cost.bean.MaterialUseEntity;

import java.util.Date;

/**
 * 原材料耗用表
 * 
 * @author generator
 * 
 */
public interface IMaterialUseService extends IBaseService<MaterialUseEntity> {
    /**
     * 计算发货数据的原材料的标准用量
     * @param startDate 开始时间
     * @param endDate   结束时间
     * @return   boolean
     */
    boolean calculateMaterialUse(Date startDate, Date endDate);
    /**
     * 按原材料和日期分组汇总消耗总量
     * @param productTime   生产时间
     * @param materialId    原材料id
     * @return
     */
    MaterialUseTotalVO queryMaterialUseTotal(String productTime, String materialId);
}
