package com.ejianc.business.cost.service.impl;

import com.ejianc.business.cost.bean.DatasummarydetailEntity;
import com.ejianc.business.cost.mapper.AdmixtureDetailMapper;
import com.ejianc.business.cost.service.IAdmixtureDetailService;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.cost.bean.AdmixtureDetailEntity;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.List;

/**
 * 外加剂投放明细
 * 
 * @author generator
 * 
 */
@Service("admixtureDetailService")
public class AdmixtureDetailServiceImpl extends BaseServiceImpl<AdmixtureDetailMapper, AdmixtureDetailEntity> implements IAdmixtureDetailService {

    @Override
    public DatasummarydetailEntity calMaterialUse(List<AdmixtureDetailEntity> list, AdmixtureDetailEntity admixtureDetailEntity, BigDecimal count) {
        DatasummarydetailEntity datasummarydetailEntity=
                BeanMapper.map(admixtureDetailEntity,DatasummarydetailEntity.class);
        datasummarydetailEntity.setId(null);
        datasummarydetailEntity.setMid(null);
        datasummarydetailEntity.setIsOldMaterial(0);
        datasummarydetailEntity.setMaterialUseTotal
                (count.multiply(admixtureDetailEntity.getMaterialThrowPercent())
                .divide(BigDecimal.TEN.multiply(BigDecimal.TEN),2, RoundingMode.HALF_UP));
        return datasummarydetailEntity;
    }
}
