package com.ejianc.business.cost.service.impl;

import com.ejianc.business.cost.bean.Aggregate10DetailEntity;
import com.ejianc.business.cost.bean.DatasummarydetailEntity;
import com.ejianc.business.cost.mapper.Aggregate10DetailMapper;
import com.ejianc.business.cost.service.IAggregate10DetailService;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.List;

/**
 * 骨料10投放明细
 * 
 * @author generator
 * 
 */
@Service("aggregate10DetailService")
public class Aggregate10DetailServiceImpl extends BaseServiceImpl<Aggregate10DetailMapper, Aggregate10DetailEntity> implements IAggregate10DetailService {

    @Override
    public DatasummarydetailEntity calMaterialUse(List<Aggregate10DetailEntity> list, Aggregate10DetailEntity aggregateDetailEntity, BigDecimal count) {
        DatasummarydetailEntity datasummarydetailEntity=
                BeanMapper.map(aggregateDetailEntity,DatasummarydetailEntity.class);
        datasummarydetailEntity.setId(null);
        datasummarydetailEntity.setMid(null);
        //计算骨料的投放综合再计算每个骨料占总和的投放比例
        BigDecimal percentCount = new BigDecimal("0");
        for (Aggregate10DetailEntity Entity : list) {
            percentCount = percentCount.add(Entity.getMaterialThrowPercent());
        }

        BigDecimal percent = aggregateDetailEntity.getMaterialThrowPercent()
                .divide(percentCount,2, RoundingMode.HALF_UP);

        datasummarydetailEntity.setIsOldMaterial(0);
        datasummarydetailEntity.setMaterialUseTotal(count.multiply(percent));
        return datasummarydetailEntity;
    }
}
