package com.ejianc.business.cost.service.impl;

import com.ejianc.business.cost.bean.Aggregate1DetailEntity;
import com.ejianc.business.cost.bean.DatasummarydetailEntity;
import com.ejianc.business.cost.mapper.Aggregate1DetailMapper;
import com.ejianc.business.cost.service.IAggregate1DetailService;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.List;

/**
 * 骨料1投放明细
 * 
 * @author generator
 * 
 */
@Service("aggregate1DetailService")
public class Aggregate1DetailServiceImpl extends BaseServiceImpl<Aggregate1DetailMapper, Aggregate1DetailEntity> implements IAggregate1DetailService {
    /**
     * 计算原材料用量
     * @param list  骨料1集合
     * @param aggregateDetailEntity  骨料1
     * @param count
     * @return
     */
    @Override
    public DatasummarydetailEntity calMaterialUse(List<Aggregate1DetailEntity> list, Aggregate1DetailEntity aggregateDetailEntity, BigDecimal count) {
        DatasummarydetailEntity datasummarydetailEntity=
                BeanMapper.map(aggregateDetailEntity,DatasummarydetailEntity.class);

        datasummarydetailEntity.setId(null);
        datasummarydetailEntity.setMid(null);
        //计算骨料的投放综合再计算每个骨料占总和的投放比例
        BigDecimal percentCount = new BigDecimal("0");
        for (Aggregate1DetailEntity entity : list) {
            percentCount = percentCount.add(entity.getMaterialThrowPercent());
        }

        BigDecimal percent = aggregateDetailEntity.getMaterialThrowPercent()
                .divide(percentCount,2, RoundingMode.HALF_UP);

        datasummarydetailEntity.setIsOldMaterial(0);
        datasummarydetailEntity.setMaterialUseTotal(count.multiply(percent));
        return datasummarydetailEntity;
    }
}
