package com.ejianc.business.cost.service.impl;

import com.ejianc.business.cost.bean.DatasummarydetailEntity;
import com.ejianc.business.cost.mapper.Aggregate2DetailMapper;
import com.ejianc.business.cost.service.IAggregate2DetailService;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.cost.bean.Aggregate2DetailEntity;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.List;

/**
 * 骨料2投放明细表
 * 
 * @author generator
 * 
 */
@Service("aggregate2DetailService")
public class Aggregate2DetailServiceImpl extends BaseServiceImpl<Aggregate2DetailMapper, Aggregate2DetailEntity> implements IAggregate2DetailService {

    @Override
    public DatasummarydetailEntity calMaterialUse(List<Aggregate2DetailEntity> list, Aggregate2DetailEntity aggregateDetailEntity, BigDecimal count) {
        DatasummarydetailEntity datasummarydetailEntity=
                BeanMapper.map(aggregateDetailEntity,DatasummarydetailEntity.class);

        datasummarydetailEntity.setId(null);
        datasummarydetailEntity.setMid(null);
        //计算骨料的投放综合再计算每个骨料占总和的投放比例
        BigDecimal percentCount = new BigDecimal("0");
        for (Aggregate2DetailEntity Entity : list) {
            percentCount = percentCount.add(Entity.getMaterialThrowPercent());
        }

        BigDecimal percent = aggregateDetailEntity.getMaterialThrowPercent()
                .divide(percentCount,2, RoundingMode.HALF_UP);

        datasummarydetailEntity.setIsOldMaterial(0);
        datasummarydetailEntity.setMaterialUseTotal(count.multiply(percent));
        return datasummarydetailEntity;
    }
}
