package com.ejianc.business.cost.service.impl;

import com.ejianc.business.cost.bean.DatasummarydetailEntity;
import com.ejianc.business.cost.mapper.Aggregate4DetailMapper;
import com.ejianc.business.cost.service.IAggregate4DetailService;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.cost.bean.Aggregate4DetailEntity;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.List;

/**
 * 骨料4投放明细
 * 
 * @author generator
 * 
 */
@Service("aggregate4DetailService")
public class Aggregate4DetailServiceImpl extends BaseServiceImpl<Aggregate4DetailMapper, Aggregate4DetailEntity> implements IAggregate4DetailService {

    @Override
    public DatasummarydetailEntity calMaterialUse(List<Aggregate4DetailEntity> list, Aggregate4DetailEntity aggregateDetailEntity, BigDecimal count) {
        DatasummarydetailEntity datasummarydetailEntity=
                BeanMapper.map(aggregateDetailEntity,DatasummarydetailEntity.class);

        datasummarydetailEntity.setId(null);
        datasummarydetailEntity.setMid(null);
        //计算骨料的投放综合再计算每个骨料占总和的投放比例
        BigDecimal percentCount = new BigDecimal("0");
        for (Aggregate4DetailEntity Entity : list) {
            percentCount=percentCount.add(Entity.getMaterialThrowPercent());
        }

        BigDecimal percent=aggregateDetailEntity.getMaterialThrowPercent()
                .divide(percentCount,2, RoundingMode.HALF_UP);

        datasummarydetailEntity.setIsOldMaterial(0);
        datasummarydetailEntity.setMaterialUseTotal(count.multiply(percent));
        return datasummarydetailEntity;
    }
}
