package com.ejianc.business.cost.service.impl;

import com.ejianc.business.cost.bean.DatasummarydetailEntity;
import com.ejianc.business.cost.mapper.Aggregate5DetailMapper;
import com.ejianc.business.cost.service.IAggregate5DetailService;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.cost.bean.Aggregate5DetailEntity;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.List;

/**
 * 骨料5投放明细
 * 
 * @author generator
 * 
 */
@Service("aggregate5DetailService")
public class Aggregate5DetailServiceImpl extends BaseServiceImpl<Aggregate5DetailMapper, Aggregate5DetailEntity> implements IAggregate5DetailService {

    @Override
    public DatasummarydetailEntity calMaterialUse(List<Aggregate5DetailEntity> list, Aggregate5DetailEntity aggregateDetailEntity, BigDecimal count) {
        DatasummarydetailEntity datasummarydetailEntity=
                BeanMapper.map(aggregateDetailEntity,DatasummarydetailEntity.class);
        datasummarydetailEntity.setId(null);
        datasummarydetailEntity.setMid(null);
        //计算骨料的投放综合再计算每个骨料占总和的投放比例
        BigDecimal percentCount = new BigDecimal("0");
        for (Aggregate5DetailEntity Entity : list) {
            percentCount=percentCount.add(Entity.getMaterialThrowPercent());
        }

        BigDecimal percent = aggregateDetailEntity.getMaterialThrowPercent()
                .divide(percentCount,2, RoundingMode.HALF_UP);

        datasummarydetailEntity.setIsOldMaterial(0);
        datasummarydetailEntity.setMaterialUseTotal(count.multiply(percent));
        return datasummarydetailEntity;
    }
}
