package com.ejianc.business.cost.service.impl;

import com.ejianc.business.cost.bean.Aggregate7DetailEntity;
import com.ejianc.business.cost.bean.DatasummarydetailEntity;
import com.ejianc.business.cost.mapper.Aggregate7DetailMapper;
import com.ejianc.business.cost.service.IAggregate7DetailService;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.List;

/**
 * 骨料7投放明细
 * 
 * @author generator
 * 
 */
@Service("aggregate7DetailService")
public class Aggregate7DetailServiceImpl extends BaseServiceImpl<Aggregate7DetailMapper, Aggregate7DetailEntity> implements IAggregate7DetailService {

    @Override
    public DatasummarydetailEntity calMaterialUse(List<Aggregate7DetailEntity> list, Aggregate7DetailEntity aggregateDetailEntity, BigDecimal count) {
        DatasummarydetailEntity datasummarydetailEntity=
                BeanMapper.map(aggregateDetailEntity,DatasummarydetailEntity.class);
        datasummarydetailEntity.setId(null);
        datasummarydetailEntity.setMid(null);
        //计算骨料的投放综合再计算每个骨料占总和的投放比例
        BigDecimal percentCount = new BigDecimal("0");

        for (Aggregate7DetailEntity Entity : list) {
            percentCount = percentCount.add(Entity.getMaterialThrowPercent());
        }

        BigDecimal percent = aggregateDetailEntity.getMaterialThrowPercent()
                .divide(percentCount,2, RoundingMode.HALF_UP);
        datasummarydetailEntity.setIsOldMaterial(0);
        datasummarydetailEntity.setMaterialUseTotal(count.multiply(percent));
        return datasummarydetailEntity;
    }
}
