package com.ejianc.business.cost.service.impl;

import com.ejianc.business.cost.bean.AsphaltsDetailEntity;
import com.ejianc.business.cost.bean.DatasummarydetailEntity;
import com.ejianc.business.cost.mapper.AsphaltsDetailMapper;
import com.ejianc.business.cost.service.IAsphaltsDetailService;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.List;

/**
 * 改性沥青投放比例
 * 
 * @author generator
 * 
 */
@Service("asphaltsDetailService")
public class AsphaltsDetailServiceImpl extends BaseServiceImpl<AsphaltsDetailMapper, AsphaltsDetailEntity> implements IAsphaltsDetailService {

    @Override
    public DatasummarydetailEntity calMaterialUse(List<AsphaltsDetailEntity> list, AsphaltsDetailEntity asphaltDetailEntity, BigDecimal count) {
        DatasummarydetailEntity datasummarydetailEntity=
                BeanMapper.map(asphaltDetailEntity,DatasummarydetailEntity.class);
        datasummarydetailEntity.setId(null);
        datasummarydetailEntity.setMid(null);

        //计算骨料的投放综合再计算每个骨料占总和的投放比例
        BigDecimal percentCount = new BigDecimal("0");
        for (AsphaltsDetailEntity Entity : list) {
            percentCount=percentCount.add(Entity.getMaterialThrowPercent());
        }

        BigDecimal percent=asphaltDetailEntity.getMaterialThrowPercent()
                .divide(percentCount,2, RoundingMode.HALF_UP);

        datasummarydetailEntity.setIsOldMaterial(0);
        datasummarydetailEntity.setMaterialUseTotal(count.multiply(percent));
        return datasummarydetailEntity;
    }
}
