package com.ejianc.business.cost.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.cost.bean.*;
import com.ejianc.business.cost.service.*;
import com.ejianc.business.cost.vo.DatasummaryTransformVO;
import com.ejianc.business.cost.vo.DatasummaryVO;
import com.ejianc.business.cost.vo.MaterialBuyVO;
import com.ejianc.business.cost.vo.MaterialUseTotalVO;
import com.ejianc.business.openapi.cost.vo.ProductDataVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.cost.mapper.DatasummaryMapper;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.*;

/**
 * 数据汇总
 * 
 * @author generator
 * 
 */
@Service("datasummaryService")
public class DatasummaryServiceImpl extends BaseServiceImpl<DatasummaryMapper, DatasummaryEntity> implements IDatasummaryService{

    @Autowired
    private IMixtureratioService service;
    @Autowired
    private IDatasummaryService datasummaryService;
    @Autowired
    private IDatatotalService datatotalService;
    @Autowired
    private IAggregate1DetailService aggregate1DetailService;
    @Autowired
    private IAggregate2DetailService aggregate2DetailService;
    @Autowired
    private IAggregate3DetailService aggregate3DetailService;
    @Autowired
    private IAggregate4DetailService aggregate4DetailService;
    @Autowired
    private IAggregate5DetailService aggregate5DetailService;
    @Autowired
    private IAggregate6DetailService aggregate6DetailService;
    @Autowired
    private IAggregate7DetailService aggregate7DetailService;
    @Autowired
    private IAggregate8DetailService aggregate8DetailService;
    @Autowired
    private IAggregate9DetailService aggregate9DetailService;
    @Autowired
    private IAggregate10DetailService aggregate10DetailService;
    @Autowired
    private IAdmixtureDetailService admixtureDetailService;
    @Autowired
    private IOldMaterialDetailService oldMaterialDetailService;
    @Autowired
    private IAsphaltDetailService asphaltDetailService;
    @Autowired
    private IPowderDetailService powderDetailService;

    @Autowired
    private DatasummaryMapper mapper;
    @Autowired
    private IBillCodeApi billCodeApi;

    private static final String BILL_CODE = "Invoice_Open_Apply_Code";//此处需要根据实际修改
    /**
     * 根据生产日期汇总查询当天的原材料的耗用量总量
     * @param productTime 生产日期
     * @param materialId   原材料id
     * @return MaterialUseTotalVO
     */
    @Override
    public MaterialUseTotalVO queryMaterialUseTotal(String productTime,String materialId) {
        Map<String, String> map = new HashMap<>();
        map.put("productTime",productTime);
        map.put("materialId",materialId);
        MaterialUseTotalVO materialUseTotalVO = mapper.queryMaterialUseTotal(map);
        if (materialUseTotalVO == null){
            materialUseTotalVO = new MaterialUseTotalVO();
            materialUseTotalVO.setMaterialId(Long.getLong(materialId));
            materialUseTotalVO.setMaterialUseTotal(BigDecimal.ZERO);
        }
        return materialUseTotalVO;
    }

    /**
     * 计算生产数据原材料用量
     * @param startDate 开始时间
     * @param endDate  结束时间
     * @param orgId   组织id
     */
    @Override
    public void calProductionData(Date startDate, Date endDate, Long orgId) {
        QueryWrapper<DatatotalEntity> queryWrapper = new QueryWrapper();
        queryWrapper.between("total_date",startDate,endDate);
        queryWrapper.eq("org_id",orgId.toString());
        List<DatatotalEntity> list = datatotalService.list(queryWrapper);
        list.forEach(element -> {
            QueryWrapper query = new QueryWrapper();
            query.eq("name",element.getMixRateName());
            query.eq("org_id",orgId.toString());
            MixtureratioEntity mixtureratioEntity = service.getOne(query);
            if (mixtureratioEntity != null){
                MixtureratioEntity entity = service.selectById(mixtureratioEntity.getId());
                DatasummaryTransformVO vo = BeanMapper.map(entity, DatasummaryTransformVO.class);
                DatasummaryEntity datasummaryEntity = BeanMapper.map(vo, DatasummaryEntity.class);
                datasummaryEntity.setProductionMixtureId(entity.getId());
                datasummaryEntity.setProductionMixtureName(entity.getName());
                datasummaryEntity.setProductTime(element.getTotalDate());
                datasummaryEntity.setProductionSum(element.getUnitSum());
                List<DatasummarydetailEntity> entities=new ArrayList<>();
                /**
                 * 骨料生产数据计算逻辑:
                 * 查询骨料的用量，计算骨料的每个原材料占整个骨料投放的占比，每个骨料的原材料的用量=骨料消耗*占比
                 */
                //骨料1 原材料用量同步
                if (!entity.getAggregate1DetailEntities().isEmpty() && element.getAggregate1() != null && element.getAggregate1().compareTo(BigDecimal.ZERO) > 0){
                    for (Aggregate1DetailEntity aggregateDetailEntity : entity.getAggregate1DetailEntities()) {
                        DatasummarydetailEntity datasummarydetailEntity =
                                aggregate1DetailService.calMaterialUse(entity.getAggregate1DetailEntities(), aggregateDetailEntity, element.getAggregate1());
                        entities.add(datasummarydetailEntity);
                    }
                }
                //骨料2 原材料用量同步
                if (!entity.getAggregate2DetailEntities().isEmpty() && element.getAggregate2() != null && element.getAggregate2().compareTo(BigDecimal.ZERO) > 0){
                    for (Aggregate2DetailEntity aggregateDetailEntity : entity.getAggregate2DetailEntities()) {
                        DatasummarydetailEntity datasummarydetailEntity =
                                aggregate2DetailService.calMaterialUse(entity.getAggregate2DetailEntities(), aggregateDetailEntity, element.getAggregate2());
                        entities.add(datasummarydetailEntity);
                    }
                }
                //骨料3 原材料用量同步
                if (!entity.getAggregate3DetailEntities().isEmpty() && element.getAggregate3() != null && element.getAggregate3().compareTo(BigDecimal.ZERO) > 0){
                    for (Aggregate3DetailEntity aggregateDetailEntity : entity.getAggregate3DetailEntities()) {
                        DatasummarydetailEntity datasummarydetailEntity =
                                aggregate3DetailService.calMaterialUse(entity.getAggregate3DetailEntities(), aggregateDetailEntity, element.getAggregate3());
                        entities.add(datasummarydetailEntity);
                    }
                }
                //骨料4 原材料用量同步
                if (!entity.getAggregate4DetailEntities().isEmpty() && element.getAggregate4() != null && element.getAggregate4().compareTo(BigDecimal.ZERO) > 0){
                    for (Aggregate4DetailEntity aggregateDetailEntity : entity.getAggregate4DetailEntities()) {
                        DatasummarydetailEntity datasummarydetailEntity =
                                aggregate4DetailService.calMaterialUse(entity.getAggregate4DetailEntities(), aggregateDetailEntity, element.getAggregate4());
                        entities.add(datasummarydetailEntity);
                    }
                }
                //骨料5 原材料用量同步
                if (!entity.getAggregate5DetailEntities().isEmpty() && element.getAggregate5() != null && element.getAggregate5().compareTo(BigDecimal.ZERO) > 0){
                    for (Aggregate5DetailEntity aggregateDetailEntity : entity.getAggregate5DetailEntities()) {
                        DatasummarydetailEntity datasummarydetailEntity =
                                aggregate5DetailService.calMaterialUse(entity.getAggregate5DetailEntities(), aggregateDetailEntity, element.getAggregate5());
                        entities.add(datasummarydetailEntity);
                    }
                }
                //骨料6 原材料用量同步
                if (!entity.getAggregate6DetailEntities().isEmpty() && element.getAggregate6() != null && element.getAggregate6().compareTo(BigDecimal.ZERO) > 0){
                    for (Aggregate6DetailEntity aggregateDetailEntity : entity.getAggregate6DetailEntities()) {
                        DatasummarydetailEntity datasummarydetailEntity =
                                aggregate6DetailService.calMaterialUse(entity.getAggregate6DetailEntities(), aggregateDetailEntity, element.getAggregate6());
                        entities.add(datasummarydetailEntity);
                    }
                }
                //骨料7 原材料用量同步
                if (!entity.getAggregate7DetailEntities().isEmpty() && element.getAggregate7() != null && element.getAggregate7().compareTo(BigDecimal.ZERO) > 0){
                    for (Aggregate7DetailEntity aggregateDetailEntity : entity.getAggregate7DetailEntities()) {
                        DatasummarydetailEntity datasummarydetailEntity =
                                aggregate7DetailService.calMaterialUse(entity.getAggregate7DetailEntities(), aggregateDetailEntity, element.getAggregate7());
                        entities.add(datasummarydetailEntity);
                    }
                }
                //骨料8 原材料用量同步
                if (!entity.getAggregate8DetailEntities().isEmpty() && element.getAggregate8() != null && element.getAggregate8().compareTo(BigDecimal.ZERO) > 0){
                    for (Aggregate8DetailEntity aggregateDetailEntity : entity.getAggregate8DetailEntities()) {
                        DatasummarydetailEntity datasummarydetailEntity =
                                aggregate8DetailService.calMaterialUse(entity.getAggregate8DetailEntities(), aggregateDetailEntity, element.getAggregate8());
                        entities.add(datasummarydetailEntity);
                    }
                }
                //骨料9 原材料用量同步
                if (!entity.getAggregate9DetailEntities().isEmpty() && element.getAggregate9() != null && element.getAggregate9().compareTo(BigDecimal.ZERO) > 0){
                    for (Aggregate9DetailEntity aggregateDetailEntity : entity.getAggregate9DetailEntities()) {
                        DatasummarydetailEntity datasummarydetailEntity =
                                aggregate9DetailService.calMaterialUse(entity.getAggregate9DetailEntities(), aggregateDetailEntity, element.getAggregate9());
                        entities.add(datasummarydetailEntity);
                    }
                }
                //骨料10 原材料用量同步
                if (!entity.getAggregate10DetailEntities().isEmpty() && element.getAggregate10() != null && element.getAggregate10().compareTo(BigDecimal.ZERO) > 0){
                    for (Aggregate10DetailEntity aggregateDetailEntity : entity.getAggregate10DetailEntities()) {
                        DatasummarydetailEntity datasummarydetailEntity =
                                aggregate10DetailService.calMaterialUse(entity.getAggregate10DetailEntities(), aggregateDetailEntity, element.getAggregate10());
                        entities.add(datasummarydetailEntity);
                    }
                }
                //外加剂用量同步
                if (!entity.getAdmixtureDetailEntities().isEmpty() && element.getUnitSum() != null && element.getUnitSum().compareTo(BigDecimal.ZERO) > 0){
                    for (AdmixtureDetailEntity aggregateDetailEntity : entity.getAdmixtureDetailEntities()) {
                        DatasummarydetailEntity datasummarydetailEntity =
                                admixtureDetailService.calMaterialUse(entity.getAdmixtureDetailEntities(), aggregateDetailEntity, element.getUnitSum());
                        entities.add(datasummarydetailEntity);
                    }
                }
                //旧料用量同步
                if (!entity.getOldMaterialDetailEntities().isEmpty() && element.getOldMaterial() != null && element.getOldMaterial().compareTo(BigDecimal.ZERO) > 0){
                    for (OldMaterialDetailEntity aggregateDetailEntity : entity.getOldMaterialDetailEntities()) {
                        DatasummarydetailEntity datasummarydetailEntity =
                                oldMaterialDetailService.calMaterialUse(entity.getOldMaterialDetailEntities(), aggregateDetailEntity, element.getOldMaterial());
                        entities.add(datasummarydetailEntity);
                    }
                }
                //粉料用量同步
                if (!entity.getPowderDetailEntities().isEmpty() && element.getMineralPowder() != null && element.getMineralPowder().compareTo(BigDecimal.ZERO) > 0){
                    for (PowderDetailEntity aggregateDetailEntity : entity.getPowderDetailEntities()) {
                        DatasummarydetailEntity datasummarydetailEntity =
                                powderDetailService.calMaterialUse(entity.getPowderDetailEntities(), aggregateDetailEntity, element.getMineralPowder());
                        entities.add(datasummarydetailEntity);
                    }
                }
                //普通沥青用量同步
                if (!entity.getAsphaltDetailEntities().isEmpty() && element.getAsphalt() != null && element.getAsphalt().compareTo(BigDecimal.ZERO) > 0){
                    for (AsphaltDetailEntity aggregateDetailEntity : entity.getAsphaltDetailEntities() ) {
                        DatasummarydetailEntity datasummarydetailEntity =
                                asphaltDetailService.calMaterialUse(entity.getAsphaltDetailEntities(), aggregateDetailEntity, element.getAsphalt());
                        entities.add(datasummarydetailEntity);
                    }
                }
                //转换VO
                DatasummaryVO saveOrUpdateVO = BeanMapper.map(datasummaryEntity, DatasummaryVO.class);
                //生成单据编码
                BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE, InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
                CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
                if(billCode.isSuccess()) {
                    datasummaryEntity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
                }else{
                    throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
                }
                datasummaryEntity.setDatasummarydetailList(entities);
                datasummaryService.saveOrUpdate(datasummaryEntity,false);
            }
        });
    }
}
