package com.ejianc.business.cost.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.cost.mapper.MaterialBuyMapper;
import com.ejianc.business.cost.service.IDatasummaryService;
import com.ejianc.business.cost.service.IMaterialBuyService;
import com.ejianc.business.cost.vo.MaterialBuyVO;
import com.ejianc.business.cost.vo.MaterialConsumeVO;
import com.ejianc.business.cost.vo.MaterialUseTotalVO;
import com.ejianc.business.purchasingmanagement.api.SelectApi;
import com.ejianc.business.purchasingmanagement.vo.AcceptanceVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.business.cost.bean.MaterialBuyEntity;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * 本期购入数量
 * 
 * @author generator
 * 
 */
@Service("materialBuyService")
public class MaterialBuyServiceImpl extends BaseServiceImpl<MaterialBuyMapper, MaterialBuyEntity> implements IMaterialBuyService {
    @Autowired
    private IDatasummaryService datasummaryService;

    @Qualifier("com.ejianc.business.purchasingmanagement.api.SelectApi")
    @Autowired
    private SelectApi api;
    @Autowired
    private IMaterialBuyService service;
    @Autowired
    private IBillCodeApi billCodeApi;

    private static final String BILL_CODE = "Invoice_Open_Apply_Code";//此处需要根据实际修改
    ///**
    // *
    // * @param productTime 生产日期
    // * @param orgId 组织id
    // */
    @Override
    public void generateMaterialBuy(String productTime, String orgId) {
    //    List<MaterialBuyEntity> materialBuyEntities = new ArrayList<>();
    //    //按生产日期和组织查询原材料分子汇总数量
    //    List<MaterialUseTotalVO> materialUseTotalVOS = datasummaryService.queryMaterialUseTotal(productTime,orgId);
    //
    //    if (!materialUseTotalVOS.isEmpty()){
    //        for (MaterialUseTotalVO materialUseTotalVO : materialUseTotalVOS) {
    //            //查询每个原材料的本期购入数据
    //            CommonResponse<AcceptanceVO> commonResponse = api.queryMaterialAcceptance(
    //                    materialUseTotalVO.getMaterialId().toString(),
    //                    materialUseTotalVO.getProductTime().toString(),
    //                    materialUseTotalVO.getOrgId().toString()
    //            );
    //            if (commonResponse.getCode() == 0){
    //                AcceptanceVO data = commonResponse.getData();
    //                if (data.getMaterialId() != null) {
    //                    MaterialBuyEntity entity = BeanMapper.map(materialUseTotalVO, MaterialBuyEntity.class);
    //                    entity.setBuyDate(materialUseTotalVO.getProductTime());
    //                    entity.setAccount(data.getAcceptanceQuantity());
    //                    entity.setAmount(data.getAmount());
    //                    entity.setPrice(data.getPrice());
    //                    //转换VO
    //                    MaterialBuyVO saveOrUpdateVO = BeanMapper.map(entity, MaterialBuyVO.class);
    //                    //生成单据编码
    //                    BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE, InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
    //                    CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
    //                    if(billCode.isSuccess()) {
    //                        entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
    //                    }else{
    //                        throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
    //                    }
    //                    materialBuyEntities.add(entity);
    //                }
    //            }
    //        }
    //    }
    //    service.saveBatch(materialBuyEntities);
    }

    /**
     *
     * @param materialId 原材料id
     * @param date       查询日期条件
     * @param orgId      组织id
     * @return 原材料本期购入实体
     */

    @Override
    public MaterialBuyEntity getCurrentDateMaterialBuyEntity(Long materialId, Date date, Long orgId) {
        MaterialBuyEntity entity = new MaterialBuyEntity();
        //日期格式转换
        SimpleDateFormat sf = new SimpleDateFormat("yyyy-MM-dd");
        String acceptanceDate = sf.format(date);
        //查询原材料的相关日期的购入数据
        CommonResponse<AcceptanceVO> commonResponse =
                api.queryMaterialAcceptance
                    (materialId.toString(), acceptanceDate, orgId.toString());
        if (commonResponse.getCode() == 0){
            AcceptanceVO data = commonResponse.getData();
            if (data.getMaterialId() != null){
                entity = BeanMapper.map(data, MaterialBuyEntity.class);
                entity.setAccount(data.getAcceptanceQuantity());
            }else {
                entity.setMaterialId(materialId);
                entity.setAmount(BigDecimal.ZERO);
                entity.setAccount(BigDecimal.ZERO);
                entity.setPrice(BigDecimal.ZERO);
                entity.setOrgId(orgId);
            }
        }
        return entity;
    }

}
