package com.ejianc.business.cost.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.cost.bean.*;
import com.ejianc.business.cost.mapper.MaterialChangeMapper;
import com.ejianc.business.cost.service.IMaterialChangeService;
import com.ejianc.business.cost.service.IMaterialInventoryService;
import com.ejianc.business.cost.service.IMaterialInventorySummaryService;
import com.ejianc.business.cost.service.IMaterialStartInventoryService;
import com.ejianc.business.cost.vo.*;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * 本期调整数量
 *
 * @author generator
 */
@Service("materialChangeService")
public class MaterialChangeServiceImpl extends BaseServiceImpl<MaterialChangeMapper, MaterialChangeEntity> implements IMaterialChangeService {

    @Autowired
    IMaterialChangeService materialChangeService;
    @Autowired
    IMaterialInventorySummaryService materialInventorySummaryService;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private static final String BILL_CODE = "Materual-Change";//此处需要根据实际修改

    /**
     * 生成本期调整
     * @param materialInventorySummaryVO 材料盘点汇总VO
     */
    @Override
    public void saveMaterialChangeEntity(MaterialInventorySummaryVO materialInventorySummaryVO) {
        //转换VO
        TransFormVO transFormVO = BeanMapper.map(materialInventorySummaryVO, TransFormVO.class);
        //转换Entity
        MaterialChangeEntity materialChangeEntity = BeanMapper.map(transFormVO, MaterialChangeEntity.class);
        //数量
        materialChangeEntity.setAccount(materialInventorySummaryVO.getProfitLossQuantity());
        //金额
        materialChangeEntity.setAmount(materialInventorySummaryVO.getProfitLossAmount());
        //单价
        BigDecimal amount=materialChangeEntity.getAmount();//金额
        BigDecimal account=materialChangeEntity.getAccount();//数量
        BigDecimal newPrice=amount.divide(account,2,BigDecimal.ROUND_HALF_UP);
        materialChangeEntity.setPrice(newPrice);
        //调整日期
        materialChangeEntity.setChangeDate(materialInventorySummaryVO.getCreateTime());
        //备注
        materialChangeEntity.setRemark(materialInventorySummaryVO.getRemark());
        //单据编号
        MaterialChangeVO saveOrUpdateVO = BeanMapper.map(materialChangeEntity, MaterialChangeVO.class);
        if (materialChangeEntity.getId() == null || materialChangeEntity.getId() == 0) {
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE, InvocationInfoProxy.getTenantid(), saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                materialChangeEntity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            } else {
                throw new BusinessException("网络异常，编码生成失败，请稍后再试");
            }
        }
        materialChangeService.save(materialChangeEntity);
    }
    /**
     * 查询当前日期本期调整数据
     * @param materialId 原材料id
     * @param date       当前日期查询条件
     * @return          本期调整实体
     */
    @Override
    public MaterialChangeEntity getCurrentDateMaterialChangeEntity(Long materialId, Date date) {
        MaterialChangeEntity entity = new MaterialChangeEntity();
        //日期格式转换
        SimpleDateFormat sf = new SimpleDateFormat("yyyy-MM-dd");
        String acceptanceDate = sf.format(date);
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq("material_id",materialId);
        queryWrapper.eq("change_date",acceptanceDate);
        List<MaterialChangeEntity> list = materialChangeService.list(queryWrapper);
        BigDecimal account = BigDecimal.ZERO;
        BigDecimal amount = BigDecimal.ZERO;
        BigDecimal price = BigDecimal.ZERO;
        if (!list.isEmpty()){
            for (MaterialChangeEntity materialChangeEntity : list) {
                account = account.add(materialChangeEntity.getAccount());
                amount = amount.add(materialChangeEntity.getAmount());
            }
            price = amount.divide(account,2,BigDecimal.ROUND_HALF_UP);
        }
        entity.setMaterialId(materialId);
        entity.setAccount(account);
        entity.setAmount(amount);
        entity.setPrice(price);
        return entity;
    }

    @Override
    public void saveBatchMaterialChange(List<MaterialInventorySummaryVO> materialInventorySummaryVOS) {
        List<MaterialChangeEntity> list = new ArrayList();
        for (MaterialInventorySummaryVO materialInventorySummaryVO : materialInventorySummaryVOS) {
            //转换VO
            TransFormVO transFormVO = BeanMapper.map(materialInventorySummaryVO, TransFormVO.class);
            //转换Entity
            MaterialChangeEntity materialChangeEntity = BeanMapper.map(transFormVO, MaterialChangeEntity.class);
            //数量
            materialChangeEntity.setAccount(materialInventorySummaryVO.getProfitLossQuantity());
            //金额
            materialChangeEntity.setAmount(materialInventorySummaryVO.getProfitLossAmount());
            //单价
            BigDecimal amount=materialChangeEntity.getAmount();//金额
            BigDecimal account=materialChangeEntity.getAccount();//数量
            BigDecimal newPrice=amount.divide(account,2,BigDecimal.ROUND_HALF_UP);
            materialChangeEntity.setPrice(newPrice);
            //调整日期
            materialChangeEntity.setChangeDate(materialInventorySummaryVO.getCreateTime());
            //备注
            materialChangeEntity.setRemark(materialInventorySummaryVO.getRemark());
            //单据编号
            MaterialChangeVO saveOrUpdateVO = BeanMapper.map(materialChangeEntity, MaterialChangeVO.class);
            if (materialChangeEntity.getId() == null || materialChangeEntity.getId() == 0) {
                BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE, InvocationInfoProxy.getTenantid(), saveOrUpdateVO);
                CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
                if (billCode.isSuccess()) {
                    materialChangeEntity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
                } else {
                    throw new BusinessException("网络异常，编码生成失败，请稍后再试");
                }
            }
            list.add(materialChangeEntity);
        }
        materialChangeService.saveBatch(list,list.size());
    }
}
