package com.ejianc.business.cost.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.cost.bean.*;
import com.ejianc.business.cost.mapper.MaterialConsumeMapper;
import com.ejianc.business.cost.service.*;
import com.ejianc.business.cost.vo.MaterialConsumeVO;
import com.ejianc.business.cost.vo.MaterialInventoryVO;
import com.ejianc.business.cost.vo.MaterialUseTotalVO;
import com.ejianc.business.purchasingmanagement.api.SelectApi;
import com.ejianc.business.purchasingmanagement.vo.AcceptanceVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * 本期消耗数量
 * 
 * @author generator
 * 
 */
@Service("materialConsumeService")
public class MaterialConsumeServiceImpl extends BaseServiceImpl<MaterialConsumeMapper, MaterialConsumeEntity> implements IMaterialConsumeService {

    @Autowired
    IMaterialStartInventoryService materialStartInventoryService;
    @Autowired
    private IDatasummaryService datasummaryService;

    @Qualifier("com.ejianc.business.purchasingmanagement.api.SelectApi")
    @Autowired
    private SelectApi api;
    @Autowired
    private IMaterialConsumeService service;
    @Autowired
    private IMaterialUseService materialUseService;
    @Autowired
    private IMaterialDynamicInService materialDynamicInService;
    @Autowired
    private IMaterialDynamicOutService materialDynamicOutService;


    private static final String BILL_CODE = "Invoice_Open_Apply_Code";//此处需要根据实际修改


    /**
     * 生成原材料本期消耗数量
     * @param
     */
    @Override
    public void generateMaterialConsume(String productTime,String orgId) {
        //List<MaterialConsumeEntity> materialConsumeEntities = new ArrayList<>();
        ////查询原材料的指定时间内的原材料耗用量汇总
        //List<MaterialUseTotalVO> materialUseTotalVOS = datasummaryService.queryMaterialUseTotal(productTime,orgId);
        //if (!materialUseTotalVOS.isEmpty()){
        //    for (MaterialUseTotalVO materialUseTotalVO : materialUseTotalVOS) {
        //        //查询每一个原材料的本期购入数据
        //        CommonResponse<AcceptanceVO> commonResponse = api.queryMaterialAcceptance(
        //                materialUseTotalVO.getMaterialId().toString(),
        //                materialUseTotalVO.getProductTime().toString(),
        //                materialUseTotalVO.getOrgId().toString()
        //        );
        //        if (commonResponse.getCode() == 0){
        //            //查询到原材料的本期购入数据
        //            AcceptanceVO data = commonResponse.getData();
        //            //查询原材料的最新期初库存数据
        //            QueryWrapper<MaterialStartInventoryEntity> query = new QueryWrapper<>();
        //            query.eq("material_id",materialUseTotalVO.getMaterialId())
        //                 .orderByDesc("create_time");
        //            List<MaterialStartInventoryEntity> list = materialStartInventoryService.list(query);
        //            /**
        //             *
        //             */
        //            if (!list.isEmpty()){
        //                //获取最近的一条期初库存数据
        //                MaterialStartInventoryEntity materialStartInventoryEntity = list.get(0);
        //                //写入原材料本期消耗数据
        //                MaterialConsumeEntity materialConsumeEntity =
        //                        BeanMapper.map(materialUseTotalVO, MaterialConsumeEntity.class);
        //                materialConsumeEntity.setConsumeDate(materialUseTotalVO.getProductTime());
        //                materialConsumeEntity.setAccount(materialUseTotalVO.getMaterialUseTotal());
        //                BigDecimal accountSum = BigDecimal.ZERO;
        //                BigDecimal amountSum = BigDecimal.ZERO;
        //                if (data.getMaterialId() != null){
        //                    accountSum=materialStartInventoryEntity.getMaterialAccount()
        //                                .add(data.getAcceptanceQuantity());
        //                    amountSum=materialStartInventoryEntity.getInventoryAmount()
        //                                .add(data.getAmount());
        //                }else {
        //                    accountSum=materialStartInventoryEntity.getMaterialAccount();
        //                    amountSum=materialStartInventoryEntity.getInventoryAmount();
        //                }
        //                //写入本期消耗数据单价 单价 = (期初库存金额+本期购入金额)/(期初库存数量+本期购入数量)
        //                materialConsumeEntity.setPrice(
        //                        amountSum.divide(accountSum,2,BigDecimal.ROUND_HALF_UP)
        //                );
        //                materialConsumeEntity.setAmount(
        //                        materialConsumeEntity.getAccount().multiply(materialConsumeEntity.getPrice())
        //                );
        //                //转换VO
        //                MaterialConsumeVO saveOrUpdateVO = BeanMapper.map(materialConsumeEntity, MaterialConsumeVO.class);
        //                //生成单据编码
        //                BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE, InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
        //                CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
        //                if(billCode.isSuccess()) {
        //                    materialConsumeEntity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
        //                }else{
        //                    throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
        //                }
        //                materialConsumeEntities.add(materialConsumeEntity);
        //            }
        //        }
        //    }
        //}
        //materialConsumeService.saveBatch(materialConsumeEntities);
    }

    /**
     * 获取当前日期的原材料本期耗用量
     * @param materialId 原材料id
     * @param date       当前查询日期条件
     * @param orgId      组织id
     * @return 本期原材料消耗实体
     */
    @Override
    public MaterialConsumeEntity getCurrentDateMaterialConsumeEntity(Long materialId, Date date, Long orgId, Map<String, MaterialDynamicInEntity> map) {
        MaterialConsumeEntity entity = new MaterialConsumeEntity();
        //日期格式转换
        SimpleDateFormat sf = new SimpleDateFormat("yyyy-MM-dd");
        String acceptanceDate = sf.format(date);
        CommonResponse<AcceptanceVO> commonResponse = api.queryMaterialAcceptance(materialId.toString(), acceptanceDate, orgId.toString());
        if (commonResponse.getCode() == 0) {
            //查询到原材料的本期购入数据
            AcceptanceVO data = commonResponse.getData();
            //查询指定原材料的指定日期的消耗总量
            MaterialUseTotalVO materialUseTotalVO = datasummaryService.queryMaterialUseTotal(acceptanceDate, materialId.toString());
            //转换实体
            entity = BeanMapper.map(materialUseTotalVO, MaterialConsumeEntity.class);
            //获取计算加权平均后的单价
            BigDecimal price = service.calWeightedAverageUnitPrice(materialId, map, data);
            if (materialUseTotalVO.getMaterialUseTotal().compareTo(BigDecimal.ZERO) == 1){
                entity.setAmount(materialUseTotalVO.getMaterialUseTotal().multiply(price));
                entity.setPrice(price);
                entity.setAccount(materialUseTotalVO.getMaterialUseTotal());
            }else {
                entity.setAccount(BigDecimal.ZERO);
                entity.setAmount(BigDecimal.ZERO);
                entity.setPrice(BigDecimal.ZERO);
            }
        }
        return entity;
    }

    /**
     * 获取标准发货数据的原材料消耗数据
     * @param materialId  原材料id
     * @param date        日期
     * @param orgId       组织id
     * @param map
     * @return
     */
    @Override
    public MaterialConsumeEntity getCurrentDateStandardMaterialConsumeEntity(Long materialId, Date date, Long orgId, Map<String, MaterialDynamicOutEntity> map) {
        MaterialConsumeEntity entity = new MaterialConsumeEntity();
        //日期格式转换
        SimpleDateFormat sf = new SimpleDateFormat("yyyy-MM-dd");
        String acceptanceDate = sf.format(date);
        CommonResponse<AcceptanceVO> commonResponse = api.queryMaterialAcceptance(materialId.toString(), acceptanceDate, orgId.toString());
        if (commonResponse.getCode() == 0) {
            //查询到原材料的本期购入数据
            AcceptanceVO data = commonResponse.getData();
            //查询指定原材料的指定日期的消耗总量
            MaterialUseTotalVO materialUseTotalVO = materialUseService.queryMaterialUseTotal(acceptanceDate, materialId.toString());
            //转换实体
            entity = BeanMapper.map(materialUseTotalVO, MaterialConsumeEntity.class);
            //获取计算得到的加权平均单价
            BigDecimal price = service.calOutWeightedAverageUnitPrice(materialId, map, data);
            if (materialUseTotalVO.getMaterialUseTotal().compareTo(BigDecimal.ZERO) == 1) {
                entity.setAmount(materialUseTotalVO.getMaterialUseTotal().multiply(price));
                entity.setPrice(price);
                entity.setAccount(materialUseTotalVO.getMaterialUseTotal());
            }else {
                entity.setPrice(BigDecimal.ZERO);
                entity.setAmount(BigDecimal.ZERO);
                entity.setAccount(BigDecimal.ZERO);
            }
        }
        return entity;
    }

    @Override
    public BigDecimal calWeightedAverageUnitPrice(Long materialId, Map<String, MaterialDynamicInEntity> map,AcceptanceVO data) {
        /**
         * //计算加权平均单价 = (期初金额 + 购入金额) / (期初数量 + 购入数量)
         * 查询指定原材料的期初库存数据 期初库存数据应为此原材料的上一条期末库存数据
         * 1 如果原材料计算中有则需要获取最新计算的原材料的动态表中的期末库存
         * 2 如果原材料计算中没有则需要根据创建时间去获取最新的一条的动态表去取期末库存
         * 3 如果没有这个原材料的动态表则直接查询原材料的期初库存
         */
        //数量总和
        BigDecimal accountSum = BigDecimal.ZERO;
        //金额总和
        BigDecimal amountSum = BigDecimal.ZERO;
        MaterialDynamicInEntity dynamicInEntity = map.get(materialId.toString());
        if (dynamicInEntity == null){
            QueryWrapper<MaterialDynamicInEntity> query = new QueryWrapper<>();
            query.eq("material_id",materialId)
                    .orderByDesc("create_time");
            List<MaterialDynamicInEntity> list = materialDynamicInService.list(query);
            if (list.isEmpty()){
                QueryWrapper<MaterialStartInventoryEntity> query2 = new QueryWrapper<>();
                query2.eq("material_id",materialId)
                        .orderByDesc("create_time");
                List<MaterialStartInventoryEntity> list2 = materialStartInventoryService.list(query2);
                if (!list2.isEmpty()){
                    MaterialStartInventoryEntity materialStartInventoryEntity = list2.get(0);
                    accountSum = accountSum.add(materialStartInventoryEntity.getMaterialAccount())
                            .add(data.getAcceptanceQuantity());
                    amountSum = amountSum.add(materialStartInventoryEntity.getInventoryAmount())
                            .add(data.getAmount());
                }
            }else {
                MaterialDynamicInEntity dynamicInEntity1 = list.get(0);
                accountSum = data.getAcceptanceQuantity().add(dynamicInEntity1.getEndInventoryAccount());
                amountSum = data.getAmount().add(dynamicInEntity1.getEndInventoryAmount());
            }
        }else {
            accountSum = data.getAcceptanceQuantity().add(dynamicInEntity.getEndInventoryAccount());
            amountSum = data.getAmount().add(dynamicInEntity.getEndInventoryAmount());
        }
        BigDecimal price = amountSum.divide(accountSum, 2, BigDecimal.ROUND_HALF_UP);
        return price;
    }

    @Override
    public BigDecimal calOutWeightedAverageUnitPrice(Long materialId, Map<String, MaterialDynamicOutEntity> map, AcceptanceVO data) {
        /**
         * //计算加权平均单价 = (期初金额 + 购入金额) / (期初数量 + 购入数量)
         * 查询指定原材料的期初库存数据 期初库存数据应为此原材料的上一条期末库存数据
         * 1 如果原材料计算中有则需要获取最新计算的原材料的动态表中的期末库存
         * 2 如果原材料计算中没有则需要根据创建时间去获取最新的一条的动态表去取期末库存
         * 3 如果没有这个原材料的动态表则直接查询原材料的期初库存
         */
        //数量总和
        BigDecimal accountSum = BigDecimal.ZERO;
        //金额总和
        BigDecimal amountSum = BigDecimal.ZERO;
        MaterialDynamicOutEntity materialDynamicOutEntity = map.get(materialId.toString());
        if (materialDynamicOutEntity == null){
            QueryWrapper<MaterialDynamicOutEntity> query = new QueryWrapper<>();
            query.eq("material_id",materialId)
                    .orderByDesc("create_time");
            List<MaterialDynamicOutEntity> list = materialDynamicOutService.list(query);
            if (list.isEmpty()){
                QueryWrapper<MaterialStartInventoryEntity> query2 = new QueryWrapper<>();
                query2.eq("material_id",materialId)
                        .orderByDesc("create_time");
                List<MaterialStartInventoryEntity> list2 = materialStartInventoryService.list(query2);
                if (!list2.isEmpty()){
                    MaterialStartInventoryEntity materialStartInventoryEntity = list2.get(0);
                    accountSum = accountSum.add(materialStartInventoryEntity.getMaterialAccount())
                            .add(data.getAcceptanceQuantity());
                    amountSum = amountSum.add(materialStartInventoryEntity.getInventoryAmount())
                            .add(data.getAmount());
                }
            }else {
                MaterialDynamicOutEntity materialDynamicOutEntity1 = list.get(0);
                accountSum = data.getAcceptanceQuantity().add(materialDynamicOutEntity1.getEndInventoryAccount());
                amountSum = data.getAmount().add(materialDynamicOutEntity1.getEndInventoryAmount());
            }
        }else {
            accountSum = data.getAcceptanceQuantity().add(materialDynamicOutEntity.getEndInventoryAccount());
            amountSum = data.getAmount().add(materialDynamicOutEntity.getEndInventoryAmount());
        }
        BigDecimal price = amountSum.divide(accountSum, 2, BigDecimal.ROUND_HALF_UP);
        return price;
    }
}
