package com.ejianc.business.cost.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.cost.bean.*;
import com.ejianc.business.cost.service.*;
import com.ejianc.business.cost.utils.DateUtils;
import com.ejianc.business.cost.vo.MaterialDynamicInVO;
import com.ejianc.business.cost.vo.TransFormVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.support.idworker.util.IdWorker;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.cost.mapper.MaterialDynamicInMapper;

import java.math.BigDecimal;
import java.text.ParseException;
import java.util.*;

/**
 * 材料摊销动态表(对内)
 * 
 * @author generator
 * 
 */
@Service("materialDynamicInService")
public class MaterialDynamicInServiceImpl extends BaseServiceImpl<MaterialDynamicInMapper, MaterialDynamicInEntity> implements IMaterialDynamicInService{

    @Autowired
    IMaterialInventoryRecordService materialInventoryRecordService;
    @Autowired
    IMaterialDynamicInService service;
    @Autowired
    IMaterialStartInventoryService materialStartInventoryService;
    @Autowired
    IMaterialBuyService materialBuyService;
    @Autowired
    IMaterialConsumeService materialConsumeService;
    @Autowired
    IMaterialChangeService materialChangeService;
    @Autowired
    MaterialDynamicInMapper mapper;
    /**
     * 成本结算业务逻辑
     * 查找材料盘点中的所有原材料
     * 循环时间区间内的天数
     * 循环每一个材料盘点中的每一个原材料
     * 查找这个原材料的上一日的期末库存做为当前日的期初库存 如果未查找到则查找最近的一条期初库存数据
     * 查找当前日的本期购入数据，查找当前日的本期调整数据，查找当前日的本期消耗数据
     * 期末库存 = 期初库存 + 本期购入 + 本期调整 -本期消耗
     * 将当前日的材料动态表批量保存以便下一日的原材料写入值时查询上一日的原材料的期末库存
     */
    @Override
    public synchronized void calculateMaterialDynamicIn(Date startDate, Date endDate,Long orgId){
        QueryWrapper query = new QueryWrapper();
        query.eq("org_id",orgId);
        List<MaterialInventoryRecordEntity> list = materialInventoryRecordService.list(query);
        int daysBetween = DateUtils.getDaysBetween(startDate, endDate);
        Map<String,MaterialDynamicInEntity> map = new HashMap<>();
        for (int i = 0; i < daysBetween+1; i++) {
            if (!list.isEmpty()){
                //每次查询的开始时间条件 = 开始时间 + 当前循环需要相加的天数
                Date date=DateUtils.getAddDays(startDate,i);
                //定义材料摊销动态表批量保存集合
                List<MaterialDynamicInEntity> materialDynamicInEntities=new ArrayList<>();
                list.forEach(element -> {
                    //查找当前日期的前一天的材料动态表数据
                    MaterialDynamicInEntity oneDayAgoEntity =
                            service.getOneDayAgoEntity(element.getMaterialId(), map);
                    //查找当前日期的购入数据
                    MaterialBuyEntity currentDateMaterialBuyEntity =
                            materialBuyService.getCurrentDateMaterialBuyEntity(element.getMaterialId(), date, element.getOrgId());
                    //查询当前日期的消耗数据
                    MaterialConsumeEntity currentDateMaterialConsumeEntity =
                            materialConsumeService.getCurrentDateMaterialConsumeEntity(element.getMaterialId(), date, element.getOrgId(),map);
                    //查询当前日期的调整数据
                    MaterialChangeEntity currentDateMaterialChangeEntity =
                            materialChangeService.getCurrentDateMaterialChangeEntity(element.getMaterialId(), date);
                    if (currentDateMaterialBuyEntity.getAccount().compareTo(BigDecimal.ZERO) != 0 ||
                        currentDateMaterialChangeEntity.getAccount().compareTo(BigDecimal.ZERO) != 0 ||
                        currentDateMaterialConsumeEntity.getAccount().compareTo(BigDecimal.ZERO) != 0
                    ){
                        //定义上一天的期末库存做为下一天的期初库存
                        BigDecimal startAccount = oneDayAgoEntity.getEndInventoryAccount();
                        BigDecimal startAmount = oneDayAgoEntity.getEndInventoryAmount();
                        //计算期末数据 数量、金额、单价
                        BigDecimal endAccount = startAccount
                                .add(currentDateMaterialBuyEntity.getAccount())
                                .add(currentDateMaterialChangeEntity.getAccount())
                                .subtract(currentDateMaterialConsumeEntity.getAccount());
                        BigDecimal endAmount = startAmount
                                .add(currentDateMaterialBuyEntity.getAmount())
                                .add(currentDateMaterialChangeEntity.getAmount())
                                .subtract(currentDateMaterialConsumeEntity.getAmount());
                        TransFormVO vo = BeanMapper.map(element, TransFormVO.class);
                        MaterialDynamicInEntity entity = BeanMapper.map(vo, MaterialDynamicInEntity.class);
                        entity.setDate(date);
                        //动态表写入期初数据
                        entity.setStartInventoryAmount(startAmount);
                        entity.setStartInventoryAccount(startAccount);
                        entity.setStartInventoryPrice(startAmount.divide(startAccount, 2, BigDecimal.ROUND_HALF_UP));
                        //写入期末数据
                        entity.setEndInventoryAmount(endAmount);
                        entity.setEndInventoryAccount(endAccount);
                        entity.setEndInventoryPrice(endAmount.divide(endAccount, 2, BigDecimal.ROUND_HALF_UP));
                        //写入本期购入数据
                        entity.setThisBuyAccount(currentDateMaterialBuyEntity.getAccount());
                        entity.setThisBuyAmount(currentDateMaterialBuyEntity.getAmount());
                        entity.setThisBuyPrice(currentDateMaterialBuyEntity.getPrice());
                        //写入本期调整数据
                        entity.setThisChangeAccount(currentDateMaterialChangeEntity.getAccount());
                        entity.setThisChangeAmount(currentDateMaterialChangeEntity.getAmount());
                        entity.setThisChangePrice(currentDateMaterialChangeEntity.getPrice());
                        //写入本期消耗数据
                        entity.setThisConsumeAccount(currentDateMaterialConsumeEntity.getAccount());
                        entity.setThisConsumeAmount(currentDateMaterialConsumeEntity.getAmount());
                        entity.setThisConsumePrice(currentDateMaterialConsumeEntity.getPrice());
                        //添加到集合和map中
                        map.put(element.getMaterialId().toString(),entity);
                        materialDynamicInEntities.add(entity);
                    }
                });
                service.saveBatch(materialDynamicInEntities);
            }
        }

    }

    /**
     * 查找当前日期的前一天的材料动态表
     * @param materialId  原材料id
     * @param map         存放最新的原材料动态表map
     * @return MaterialDynamicInEntity
     */

    @Override
    public MaterialDynamicInEntity getOneDayAgoEntity(Long materialId, Map<String,MaterialDynamicInEntity> map) {
        // 根据程序中存放的原材料的材料动态表查找动态表
        MaterialDynamicInEntity dynamicInEntity = map.get(materialId.toString());
        if (dynamicInEntity == null){
            //如果为空去查根据日期降序排序的第一个原材料的动态表
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.eq("material_id",materialId);
            queryWrapper.orderByDesc("date");
            List<MaterialDynamicInEntity> list = service.list(queryWrapper);
            if (!list.isEmpty()){
                dynamicInEntity=list.get(0);
            }else {
                //如果没查到再查原材料的期初库存
                QueryWrapper query = new QueryWrapper();
                query.eq("material_id", materialId);
                query.orderByDesc("create_time");
                List<MaterialStartInventoryEntity> list1 = materialStartInventoryService.list(query);
                if (!list1.isEmpty()) {
                    MaterialStartInventoryEntity materialStartInventoryEntity = list1.get(0);
                    TransFormVO vo = BeanMapper.map(materialStartInventoryEntity, TransFormVO.class);
                    dynamicInEntity = BeanMapper.map(vo, MaterialDynamicInEntity.class);
                    dynamicInEntity.setStartInventoryAmount(materialStartInventoryEntity.getInventoryAmount());
                    dynamicInEntity.setStartInventoryAccount(materialStartInventoryEntity.getMaterialAccount());
                    dynamicInEntity.setStartInventoryPrice(materialStartInventoryEntity.getInventoryUnitPrice());
                    dynamicInEntity.setEndInventoryAccount(materialStartInventoryEntity.getMaterialAccount());
                    dynamicInEntity.setEndInventoryAmount(materialStartInventoryEntity.getInventoryAmount());
                    dynamicInEntity.setEndInventoryPrice(materialStartInventoryEntity.getInventoryUnitPrice());
                }
            }
        }
        return dynamicInEntity;
    }

    /**
     * 材料动态表汇总业务逻辑
     * 获取每个原材料得期初库存数据
     * 获取每个原材料得期末库存数据
     * 汇总每个原材料得本期购入数据，本期调整数据
     * @param  map 查询参数
     * @return
     */
    @Override
    public List<MaterialDynamicInVO> materialDynamicInTotal(Map<String,Object> map) {
        List<MaterialDynamicInVO> materialDynamicInVOS = mapper.queryMaterialDynamicInTotal(map);
        for (MaterialDynamicInVO materialDynamicInVO : materialDynamicInVOS) {
            QueryWrapper query = new QueryWrapper();
            query.eq("material_id",materialDynamicInVO.getMaterialId().toString());
            query.between("date",map.get("startDate"),map.get("endDate"));
            query.orderByAsc("date");
            List<MaterialDynamicInEntity> list = service.list(query);
            if (!list.isEmpty()){
                MaterialDynamicInEntity dynamicInEntity = list.get(0);
                materialDynamicInVO.setStartInventoryAccount(dynamicInEntity.getStartInventoryAccount());
                materialDynamicInVO.setStartInventoryAmount(dynamicInEntity.getStartInventoryAmount());
                materialDynamicInVO.setStartInventoryPrice(dynamicInEntity.getStartInventoryPrice());
                MaterialDynamicInEntity dynamicInEntity1 = list.get(list.size()-1);
                materialDynamicInVO.setEndInventoryAccount(dynamicInEntity1.getEndInventoryAccount());
                materialDynamicInVO.setEndInventoryAmount(dynamicInEntity1.getEndInventoryAmount());
                materialDynamicInVO.setEndInventoryPrice(dynamicInEntity1.getEndInventoryPrice());
            }
            if (materialDynamicInVO.getThisChangePrice() == null)
                materialDynamicInVO.setThisChangePrice(BigDecimal.ZERO);
            if (materialDynamicInVO.getThisBuyPrice() == null)
                materialDynamicInVO.setThisBuyPrice(BigDecimal.ZERO);
            if (materialDynamicInVO.getThisConsumePrice() == null)
                materialDynamicInVO.setThisConsumePrice(BigDecimal.ZERO);
            materialDynamicInVO.setId(IdWorker.getId());
        }
        return materialDynamicInVOS;
    }
}
