package com.ejianc.business.cost.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.cost.bean.*;
import com.ejianc.business.cost.service.*;
import com.ejianc.business.cost.utils.DateUtils;
import com.ejianc.business.cost.vo.MaterialDynamicInVO;
import com.ejianc.business.cost.vo.MaterialDynamicOutVO;
import com.ejianc.business.cost.vo.TransFormVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.support.idworker.util.IdWorker;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.cost.mapper.MaterialDynamicOutMapper;

import java.math.BigDecimal;
import java.util.*;

/**
 * 材料摊销动态表(对外)
 * 
 * @author generator
 * 
 */
@Service("materialDynamicOutService")
public class MaterialDynamicOutServiceImpl extends BaseServiceImpl<MaterialDynamicOutMapper, MaterialDynamicOutEntity> implements IMaterialDynamicOutService{

    @Autowired
    IMaterialInventoryRecordService materialInventoryRecordService;
    @Autowired
    IMaterialDynamicOutService service;
    @Autowired
    IMaterialStartInventoryService materialStartInventoryService;
    @Autowired
    IMaterialBuyService materialBuyService;
    @Autowired
    IMaterialConsumeService materialConsumeService;
    @Autowired
    IMaterialChangeService materialChangeService;
    @Autowired
    MaterialDynamicOutMapper mapper;
    /**
     * 标准成本结算
     * @param startDate 开始时间
     * @param endDate  结束时间
     */
    @Override
    public synchronized void calculateMaterialDynamicOut(Date startDate, Date endDate, Long orgId) {
        QueryWrapper query = new QueryWrapper();
        query.eq("org_id",orgId);
        List<MaterialInventoryRecordEntity> list = materialInventoryRecordService.list(query);
        int daysBetween = DateUtils.getDaysBetween(startDate, endDate);
        Map<String,MaterialDynamicOutEntity> map = new HashMap<>();
        for (int i = 0; i < daysBetween+1; i++) {
            if (!list.isEmpty()){
                //每次查询的开始时间条件 = 开始时间 + 当前循环需要相加的天数
                Date date=DateUtils.getAddDays(startDate,i);
                //定义材料摊销动态表批量保存集合
                List<MaterialDynamicOutEntity> materialDynamicOutEntities=new ArrayList<>();
                list.forEach(element -> {
                    //查找当前日期的前一天的材料动态表数据
                    MaterialDynamicOutEntity oneDayAgoEntity =
                            service.getOneDayAgoEntity(element.getMaterialId(), map);
                    //查找当前日期的购入数据
                    MaterialBuyEntity currentDateMaterialBuyEntity =
                            materialBuyService.getCurrentDateMaterialBuyEntity(element.getMaterialId(), date, element.getOrgId());
                    //查询当前日期的消耗数据
                    MaterialConsumeEntity currentDateMaterialConsumeEntity =
                            materialConsumeService.getCurrentDateStandardMaterialConsumeEntity(element.getMaterialId(), date, element.getOrgId(),map);
                    //查询当前日期的调整数据
                    MaterialChangeEntity currentDateMaterialChangeEntity =
                            materialChangeService.getCurrentDateMaterialChangeEntity(element.getMaterialId(), date);
                    if (currentDateMaterialBuyEntity.getAccount().compareTo(BigDecimal.ZERO) != 0 ||
                            currentDateMaterialChangeEntity.getAccount().compareTo(BigDecimal.ZERO) != 0 ||
                            currentDateMaterialConsumeEntity.getAccount().compareTo(BigDecimal.ZERO) != 0
                    ){
                        //定义上一天的期末库存做为下一天的期初库存
                        BigDecimal startAccount = oneDayAgoEntity.getEndInventoryAccount();
                        BigDecimal startAmount = oneDayAgoEntity.getEndInventoryAmount();
                        //计算期末数据 数量、金额、单价
                        BigDecimal endAccount = startAccount
                                .add(currentDateMaterialBuyEntity.getAccount())
                                .add(currentDateMaterialChangeEntity.getAccount())
                                .subtract(currentDateMaterialConsumeEntity.getAccount());
                        BigDecimal endAmount = startAmount
                                .add(currentDateMaterialBuyEntity.getAmount())
                                .add(currentDateMaterialChangeEntity.getAmount())
                                .subtract(currentDateMaterialConsumeEntity.getAmount());
                        TransFormVO vo = BeanMapper.map(element, TransFormVO.class);
                        MaterialDynamicOutEntity entity = BeanMapper.map(vo, MaterialDynamicOutEntity.class);
                        entity.setDate(date);
                        //动态表写入期初数据
                        entity.setStartInventoryAmount(startAmount);
                        entity.setStartInventoryAccount(startAccount);
                        entity.setStartInventoryPrice(startAmount.divide(startAccount, 2, BigDecimal.ROUND_HALF_UP));
                        //写入期末数据
                        entity.setEndInventoryAmount(endAmount);
                        entity.setEndInventoryAccount(endAccount);
                        entity.setEndInventoryPrice(endAmount.divide(endAccount, 2, BigDecimal.ROUND_HALF_UP));
                        //写入本期购入数据
                        entity.setThisBuyAccount(currentDateMaterialBuyEntity.getAccount());
                        entity.setThisBuyAmount(currentDateMaterialBuyEntity.getAmount());
                        entity.setThisBuyPrice(currentDateMaterialBuyEntity.getPrice());
                        //写入本期调整数据
                        entity.setThisChangeAccount(currentDateMaterialChangeEntity.getAccount());
                        entity.setThisChangeAmount(currentDateMaterialChangeEntity.getAmount());
                        entity.setThisChangePrice(currentDateMaterialChangeEntity.getPrice());
                        //写入本期消耗数据
                        entity.setThisConsumeAccount(currentDateMaterialConsumeEntity.getAccount());
                        entity.setThisConsumeAmount(currentDateMaterialConsumeEntity.getAmount());
                        entity.setThisConsumePrice(currentDateMaterialConsumeEntity.getPrice());
                        //添加到集合和map中
                        map.put(element.getMaterialId().toString(),entity);
                        materialDynamicOutEntities.add(entity);
                    }
                });
                service.saveBatch(materialDynamicOutEntities);
            }
        }

    }
    /**
     * 查询当前日期前一天的材料动态表数据
     * @param materialId 原材料id
     * @param map    原材料id对应的上一次的动态表
     * @return
     */
    @Override
    public MaterialDynamicOutEntity getOneDayAgoEntity(Long materialId, Map<String, MaterialDynamicOutEntity> map) {
        // 根据程序中存放的原材料的材料动态表查找动态表
        MaterialDynamicOutEntity dynamicInEntity = map.get(materialId.toString());
        if (dynamicInEntity == null){
            //如果为空去查根据日期降序排序的第一个原材料的动态表
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.eq("material_id",materialId);
            queryWrapper.orderByDesc("date");
            List<MaterialDynamicOutEntity> list = service.list(queryWrapper);
            if (!list.isEmpty()){
                dynamicInEntity=list.get(0);
            }else {
                //如果没查到再查原材料的期初库存
                QueryWrapper query = new QueryWrapper();
                query.eq("material_id", materialId);
                query.orderByDesc("create_time");
                List<MaterialStartInventoryEntity> list1 = materialStartInventoryService.list(query);
                if (!list1.isEmpty()) {
                    MaterialStartInventoryEntity materialStartInventoryEntity = list1.get(0);
                    TransFormVO vo = BeanMapper.map(materialStartInventoryEntity, TransFormVO.class);
                    dynamicInEntity = BeanMapper.map(vo, MaterialDynamicOutEntity.class);
                    dynamicInEntity.setStartInventoryAmount(materialStartInventoryEntity.getInventoryAmount());
                    dynamicInEntity.setStartInventoryAccount(materialStartInventoryEntity.getMaterialAccount());
                    dynamicInEntity.setStartInventoryPrice(materialStartInventoryEntity.getInventoryUnitPrice());
                    dynamicInEntity.setEndInventoryAccount(materialStartInventoryEntity.getMaterialAccount());
                    dynamicInEntity.setEndInventoryAmount(materialStartInventoryEntity.getInventoryAmount());
                    dynamicInEntity.setEndInventoryPrice(materialStartInventoryEntity.getInventoryUnitPrice());
                }
            }
        }
        return dynamicInEntity;
    }

    @Override
    public List<MaterialDynamicOutVO> materialDynamicOutTotal(Map<String,Object> map) {
        List<MaterialDynamicOutVO> materialDynamicOutVOS = mapper.queryMaterialDynamicInTotal(map);
        for (MaterialDynamicOutVO materialDynamicOutVO : materialDynamicOutVOS) {
            QueryWrapper query = new QueryWrapper();
            query.eq("material_id",materialDynamicOutVO.getMaterialId().toString());
            query.between("date",map.get("startDate"),map.get("endDate"));
            query.orderByAsc("date");
            List<MaterialDynamicOutEntity> list = service.list(query);
            if (!list.isEmpty()){
                MaterialDynamicOutEntity dynamicInEntity = list.get(0);
                materialDynamicOutVO.setStartInventoryAccount(dynamicInEntity.getStartInventoryAccount());
                materialDynamicOutVO.setStartInventoryAmount(dynamicInEntity.getStartInventoryAmount());
                materialDynamicOutVO.setStartInventoryPrice(dynamicInEntity.getStartInventoryPrice());
                MaterialDynamicOutEntity dynamicInEntity1 = list.get(list.size()-1);
                materialDynamicOutVO.setEndInventoryAccount(dynamicInEntity1.getEndInventoryAccount());
                materialDynamicOutVO.setEndInventoryAmount(dynamicInEntity1.getEndInventoryAmount());
                materialDynamicOutVO.setEndInventoryPrice(dynamicInEntity1.getEndInventoryPrice());
            }
            if (materialDynamicOutVO.getThisChangePrice() == null)
                materialDynamicOutVO.setThisChangePrice(BigDecimal.ZERO);
            if (materialDynamicOutVO.getThisBuyPrice() == null)
                materialDynamicOutVO.setThisBuyPrice(BigDecimal.ZERO);
            if (materialDynamicOutVO.getThisConsumePrice() == null)
                materialDynamicOutVO.setThisConsumePrice(BigDecimal.ZERO);
            materialDynamicOutVO.setId(IdWorker.getId());
        }
        return materialDynamicOutVOS;
    }
}
