package com.ejianc.business.cost.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.cost.bean.MaterialDynamicInEntity;
import com.ejianc.business.cost.bean.MaterialInventorySummaryEntity;
import com.ejianc.business.cost.bean.MaterialStartInventoryEntity;
import com.ejianc.business.cost.mapper.MaterialInventorySummaryMapper;
import com.ejianc.business.cost.service.IMaterialDynamicInService;
import com.ejianc.business.cost.service.IMaterialInventorySummaryService;
import com.ejianc.business.cost.service.IMaterialStartInventoryService;
import com.ejianc.business.cost.vo.MaterialInventorySummaryVO;
import com.ejianc.business.cost.vo.MaterialInventoryVO;
import com.ejianc.business.cost.vo.TransFormVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import java.math.BigDecimal;

import java.util.ArrayList;
import java.util.List;

/**
 * 盘点汇总表
 *
 * @author generator
 */
@Service("materialInventorySummaryService")
public class MaterialInventorySummaryServiceImpl extends BaseServiceImpl<MaterialInventorySummaryMapper, MaterialInventorySummaryEntity> implements IMaterialInventorySummaryService {
    @Autowired
    IMaterialStartInventoryService service;
    @Autowired
    IMaterialDynamicInService materialDynamicInService;
    @Autowired
    IMaterialInventorySummaryService materialInventorySummaryService;
    @Autowired
    private IBillCodeApi billCodeApi;

    private static final String BILL_CODE = "materialInventory-sum";//此处需要根据实际修改

    /**
     * 生成材料盘点汇总业务逻辑
     * 以期初库存为基准，按照盘点数量计算盈亏数量和金额
     * 期初库存先查询动态表的原材料的最新的一次期末库存做为期初库存 没查到则查期初库存数据
     * @param materialInventoryVO
     * @return
     */
    @Override
    public MaterialInventorySummaryVO saveMaterialInventorySummaryEntity(MaterialInventoryVO materialInventoryVO) {
        MaterialInventorySummaryEntity materialInventorySummaryEntity = null;
        QueryWrapper<MaterialDynamicInEntity> query = new QueryWrapper<>();
        query.eq("material_Id",materialInventoryVO.getMaterialId());
        query.le("date",materialInventoryVO.getInventoryDate());
        query.orderByDesc("date");
        List<MaterialDynamicInEntity> list1 = materialDynamicInService.list(query);
        if (!list1.isEmpty()){
            MaterialDynamicInEntity dynamicInEntity = list1.get(0);
            TransFormVO vo = BeanMapper.map(dynamicInEntity, TransFormVO.class);
            materialInventorySummaryEntity = BeanMapper.map(vo, MaterialInventorySummaryEntity.class);
            materialInventorySummaryEntity.setInventoryDate(materialInventoryVO.getInventoryDate());
            materialInventorySummaryEntity.setPrice(dynamicInEntity.getEndInventoryPrice());
            // 盘点数量
            materialInventorySummaryEntity.setInventoryQuantity
                    (materialInventoryVO.getMaterialAccount());
            //盘点金额 = 盘点数量 * 盘点金额
            materialInventorySummaryEntity.setInventoryAccount
                    (dynamicInEntity.getEndInventoryPrice().multiply(materialInventoryVO.getMaterialAccount()));
            //当前账面数量
            materialInventorySummaryEntity.setCurrentQuantity
                    (dynamicInEntity.getEndInventoryAccount());
            //当前金额
            materialInventorySummaryEntity.setCurrentAmount
                    (dynamicInEntity.getEndInventoryAmount());
            //盈亏金额 = 盘点金额 - 当前账面金额
            materialInventorySummaryEntity.setProfitLossAmount
                    (materialInventorySummaryEntity.getInventoryAccount()
                            .subtract(materialInventorySummaryEntity.getCurrentAmount()));
            //盈亏数量 = 盘点数量 - 当前账面数量
            materialInventorySummaryEntity.setProfitLossQuantity
                    (materialInventorySummaryEntity.getInventoryQuantity()
                            .subtract(materialInventorySummaryEntity.getCurrentQuantity()));

        }else {
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.eq("material_Id", materialInventoryVO.getMaterialId());
            queryWrapper.orderByDesc("create_time");
            List<MaterialStartInventoryEntity> list = service.list(queryWrapper);
            if (!list.isEmpty()) {
                MaterialStartInventoryEntity materialStartInventoryEntity = list.get(0);
                //转换共同属性字段
                TransFormVO transFormVO = BeanMapper.map(materialStartInventoryEntity, TransFormVO.class);
                materialInventorySummaryEntity = BeanMapper.map(transFormVO, MaterialInventorySummaryEntity.class);
                //获取单价
                BigDecimal price = materialStartInventoryEntity.getInventoryUnitPrice();
                //盘点汇总 单价 = 期初库存单价
                materialInventorySummaryEntity.setPrice(price);
                // 盘点数量
                materialInventorySummaryEntity.setInventoryQuantity
                        (materialInventoryVO.getMaterialAccount());
                //盘点金额 = 盘点数量 * 盘点金额
                materialInventorySummaryEntity.setInventoryAccount
                        (price.multiply(materialInventoryVO.getMaterialAccount()));
                //当前账面数量
                materialInventorySummaryEntity.setCurrentQuantity
                        (materialStartInventoryEntity.getMaterialAccount());
                //当前金额
                materialInventorySummaryEntity.setCurrentAmount
                        (materialStartInventoryEntity.getInventoryAmount());
                //盈亏金额 = 盘点金额 - 当前账面金额
                materialInventorySummaryEntity.setProfitLossAmount
                        (materialInventorySummaryEntity.getInventoryAccount()
                                .subtract(materialInventorySummaryEntity.getCurrentAmount()));
                //盈亏数量 = 盘点数量 - 当前账面数量
                materialInventorySummaryEntity.setProfitLossQuantity
                        (materialInventorySummaryEntity.getInventoryQuantity()
                                .subtract(materialInventorySummaryEntity.getCurrentQuantity()));
            }
        }
        //单据编号
        MaterialInventorySummaryVO saveOrUpdateVO = BeanMapper.map(materialInventorySummaryEntity, MaterialInventorySummaryVO.class);
        if (materialInventorySummaryEntity.getId() == null || materialInventorySummaryEntity.getId() == 0) {
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE, InvocationInfoProxy.getTenantid(), saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                materialInventorySummaryEntity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            } else {
                throw new BusinessException("网络异常，编码生成失败，请稍后再试");
            }
        }
        //保存
        materialInventorySummaryService.save(materialInventorySummaryEntity);
        MaterialInventorySummaryVO materialInventorySummaryVO=BeanMapper.map(materialInventorySummaryEntity, MaterialInventorySummaryVO.class);
        return materialInventorySummaryVO;
    }

    @Override
    public List<MaterialInventorySummaryVO> saveBatchMaterialInventorySummary(List<MaterialInventoryVO> materialInventoryVOS) {
        List<MaterialInventorySummaryEntity> list2 = new ArrayList<>();
        for (MaterialInventoryVO materialInventoryVO : materialInventoryVOS) {
            MaterialInventorySummaryEntity materialInventorySummaryEntity = null;
            QueryWrapper<MaterialDynamicInEntity> query = new QueryWrapper<>();
            query.eq("material_Id",materialInventoryVO.getMaterialId());
            query.le("date",materialInventoryVO.getInventoryDate());
            query.orderByDesc("date");
            List<MaterialDynamicInEntity> list1 = materialDynamicInService.list(query);
            if (!list1.isEmpty()){
                MaterialDynamicInEntity dynamicInEntity = list1.get(0);
                TransFormVO vo = BeanMapper.map(dynamicInEntity, TransFormVO.class);
                materialInventorySummaryEntity = BeanMapper.map(vo, MaterialInventorySummaryEntity.class);
                materialInventorySummaryEntity.setInventoryDate(materialInventoryVO.getInventoryDate());
                materialInventorySummaryEntity.setPrice(dynamicInEntity.getEndInventoryPrice());
                // 盘点数量
                materialInventorySummaryEntity.setInventoryQuantity
                        (materialInventoryVO.getMaterialAccount());
                //盘点金额 = 盘点数量 * 盘点金额
                materialInventorySummaryEntity.setInventoryAccount
                        (dynamicInEntity.getEndInventoryPrice().multiply(materialInventoryVO.getMaterialAccount()));
                //当前账面数量
                materialInventorySummaryEntity.setCurrentQuantity
                        (dynamicInEntity.getEndInventoryAccount());
                //当前金额
                materialInventorySummaryEntity.setCurrentAmount
                        (dynamicInEntity.getEndInventoryAmount());
                //盈亏金额 = 盘点金额 - 当前账面金额
                materialInventorySummaryEntity.setProfitLossAmount
                        (materialInventorySummaryEntity.getInventoryAccount()
                                .subtract(materialInventorySummaryEntity.getCurrentAmount()));
                //盈亏数量 = 盘点数量 - 当前账面数量
                materialInventorySummaryEntity.setProfitLossQuantity
                        (materialInventorySummaryEntity.getInventoryQuantity()
                                .subtract(materialInventorySummaryEntity.getCurrentQuantity()));

            }else {
                QueryWrapper queryWrapper = new QueryWrapper();
                queryWrapper.eq("material_Id", materialInventoryVO.getMaterialId());
                queryWrapper.orderByDesc("create_time");
                List<MaterialStartInventoryEntity> list = service.list(queryWrapper);
                if (!list.isEmpty()) {
                    MaterialStartInventoryEntity materialStartInventoryEntity = list.get(0);
                    //转换共同属性字段
                    TransFormVO transFormVO = BeanMapper.map(materialStartInventoryEntity, TransFormVO.class);
                    materialInventorySummaryEntity = BeanMapper.map(transFormVO, MaterialInventorySummaryEntity.class);
                    materialInventorySummaryEntity.setInventoryDate(materialInventoryVO.getInventoryDate());
                    //获取单价
                    BigDecimal price = materialStartInventoryEntity.getInventoryUnitPrice();
                    //盘点汇总 单价 = 期初库存单价
                    materialInventorySummaryEntity.setPrice(price);
                    // 盘点数量
                    materialInventorySummaryEntity.setInventoryQuantity
                            (materialInventoryVO.getMaterialAccount());
                    //盘点金额 = 盘点数量 * 盘点金额
                    materialInventorySummaryEntity.setInventoryAccount
                            (price.multiply(materialInventoryVO.getMaterialAccount()));
                    //当前账面数量
                    materialInventorySummaryEntity.setCurrentQuantity
                            (materialStartInventoryEntity.getMaterialAccount());
                    //当前金额
                    materialInventorySummaryEntity.setCurrentAmount
                            (materialStartInventoryEntity.getInventoryAmount());
                    //盈亏金额 = 盘点金额 - 当前账面金额
                    materialInventorySummaryEntity.setProfitLossAmount
                            (materialInventorySummaryEntity.getInventoryAccount()
                                    .subtract(materialInventorySummaryEntity.getCurrentAmount()));
                    //盈亏数量 = 盘点数量 - 当前账面数量
                    materialInventorySummaryEntity.setProfitLossQuantity
                            (materialInventorySummaryEntity.getInventoryQuantity()
                                    .subtract(materialInventorySummaryEntity.getCurrentQuantity()));
                }
            }
            //单据编号
            MaterialInventorySummaryVO saveOrUpdateVO = BeanMapper.map(materialInventorySummaryEntity, MaterialInventorySummaryVO.class);
            if (materialInventorySummaryEntity.getId() == null || materialInventorySummaryEntity.getId() == 0) {
                BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE, InvocationInfoProxy.getTenantid(), saveOrUpdateVO);
                CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
                if (billCode.isSuccess()) {
                    materialInventorySummaryEntity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
                } else {
                    throw new BusinessException("网络异常，编码生成失败，请稍后再试");
                }
            }
            list2.add(materialInventorySummaryEntity);
        }
        //批量保存
        materialInventorySummaryService.saveBatch(list2,list2.size());
        List<MaterialInventorySummaryVO> materialInventorySummaryVOS = BeanMapper.mapList(list2, MaterialInventorySummaryVO.class);
        return materialInventorySummaryVOS;
    }
}
