package com.ejianc.business.cost.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.base.bases.api.BaseSelectApi;
import com.ejianc.business.base.bases.vo.QueryProductMixDetailVO;
import com.ejianc.business.base.bases.vo.QueryProductMixVO;
import com.ejianc.business.cost.bean.MaterialDynamicOutEntity;
import com.ejianc.business.cost.bean.MaterialStartInventoryEntity;
import com.ejianc.business.cost.bean.MaterialUseDetailEntity;
import com.ejianc.business.cost.service.IMaterialDynamicOutService;
import com.ejianc.business.cost.service.IMaterialStartInventoryService;
import com.ejianc.business.cost.utils.DateUtils;
import com.ejianc.business.cost.vo.MaterialUseTotalVO;
import com.ejianc.business.cost.vo.MaterialUseVO;
import com.ejianc.business.purchasingmanagement.api.SelectApi;
import com.ejianc.business.purchasingmanagement.vo.AcceptanceVO;
import com.ejianc.business.sale.salesorder.api.SaleSelectApi;
import com.ejianc.business.sale.salesorder.vo.NetweightSumVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.cost.mapper.MaterialUseMapper;
import com.ejianc.business.cost.bean.MaterialUseEntity;
import com.ejianc.business.cost.service.IMaterialUseService;

import java.math.BigDecimal;
import java.text.ParseException;
import java.util.*;

/**
 * 原材料耗用表
 * 
 * @author generator
 * 
 */
@Service("materialUseService")
public class MaterialUseServiceImpl extends BaseServiceImpl<MaterialUseMapper, MaterialUseEntity> implements IMaterialUseService{
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Qualifier("com.ejianc.business.sale.salesorder.api.SaleSelectApi")
    @Autowired
    private SaleSelectApi saleSelectApi;
    @Qualifier("com.ejianc.business.base.bases.api.BaseSelectApi")
    @Autowired
    private BaseSelectApi baseSelectApi;
    @Qualifier("com.ejianc.business.purchasingmanagement.api.SelectApi")
    @Autowired
    private SelectApi api;
    @Autowired
    private IMaterialUseService service;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IMaterialDynamicOutService materialDynamicOutService;
    @Autowired
    IMaterialStartInventoryService materialStartInventoryService;
    @Autowired
    private MaterialUseMapper mapper;
    private static final String BILL_CODE = "Invoice_Open_Apply_Code";//此处需要根据实际修改

    /**
     * 计算发货数据的原材料的标准用量
     * @param startDate 开始时间
     * @param endDate   结束时间
     * @return   boolean
     */
    @Override
    public synchronized boolean calculateMaterialUse(Date startDate, Date endDate) {
        //根据时间区间查询发货汇总数量
        CommonResponse<List<NetweightSumVO>> common =
                saleSelectApi.queryNetweightSum(DateUtils.getStringDate(startDate), DateUtils.getStringDate(endDate));
        if (common.getCode() == 0 && !common.getData().isEmpty()){
            for (NetweightSumVO data : common.getData()) {
                QueryProductMixVO queryProductMixVO = baseSelectApi.queryStandardMix(data.getProductId());
                if (queryProductMixVO.getName() != null ){
                    Map<String,MaterialStartInventoryEntity> map1 = new HashMap<>();
                    MaterialUseEntity entity = BeanMapper.map(queryProductMixVO, MaterialUseEntity.class);
                    entity.setId(null);
                    entity.setProductionMixtureId(queryProductMixVO.getId());
                    entity.setProductionMixtureName(queryProductMixVO.getName());
                    entity.setNetWeightSum(data.getNetWeightSum());
                    try {
                        entity.setProductTime(DateUtils.getDate(data.getShipDates()));
                    } catch (ParseException e) {
                        e.printStackTrace();
                    }
                    List<MaterialUseDetailEntity> list = new ArrayList<>();
                    for (QueryProductMixDetailVO vo : queryProductMixVO.getProductMixDetailList()) {
                        MaterialUseDetailEntity map = BeanMapper.map(vo, MaterialUseDetailEntity.class);
                        //计算原材料的标准耗用量  =  投放比例 * 发货数量总和 / 100
                        map.setMaterialUseTotal(vo.getPercent().multiply(data.getNetWeightSum())
                                .divide(BigDecimal.TEN.multiply(BigDecimal.TEN),2,BigDecimal.ROUND_HALF_UP));
                        //此处应查询此原材料的购入数据 计算平均单价
                        BigDecimal price = this.calWeightedAverageUnitPrice(map.getMaterialId(), data.getShipDates(), map1, entity.getOrgId());
                        map.setPrice(price);
                        map.setAmount(price.multiply(map.getMaterialUseTotal()));
                        //获取原材料对应的期初库存数据
                        MaterialStartInventoryEntity materialStartInventory = this.getMaterialStartInventory(map.getMaterialId(), data.getShipDates(),map1);
                        //动态计算原材料对应的期初库存数据
                        materialStartInventory.setMaterialAccount(materialStartInventory.getMaterialAccount().subtract(map.getMaterialUseTotal()));
                        materialStartInventory.setInventoryAmount(materialStartInventory.getInventoryAmount().subtract(map.getAmount()));
                        materialStartInventory.setInventoryUnitPrice(materialStartInventory.getInventoryAmount().divide(materialStartInventory.getMaterialAccount(),2,BigDecimal.ROUND_HALF_UP));
                        map1.put(map.getMaterialId().toString(),materialStartInventory);
                        list.add(map);
                    }
                    entity.setMaterialUseEntities(list);
                    MaterialUseVO saveOrUpdateVO = BeanMapper.map(entity, MaterialUseVO.class);
                    BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE, InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
                    CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
                    if(billCode.isSuccess()) {
                        entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
                    }else{
                        throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
                    }
                    service.saveOrUpdate(entity,false);
                }
            }
        }
        return true;
    }

    @Override
    public MaterialUseTotalVO queryMaterialUseTotal(String productTime, String materialId) {
        Map<String, String> map = new HashMap<>();
        map.put("productTime",productTime);
        map.put("materialId",materialId);
        MaterialUseTotalVO materialUseTotalVO = mapper.queryMaterialUseTotal(map);
        if (materialUseTotalVO == null){
            materialUseTotalVO = new MaterialUseTotalVO();
            materialUseTotalVO.setMaterialId(Long.getLong(materialId));
            materialUseTotalVO.setMaterialUseTotal(BigDecimal.ZERO);
        }
        return materialUseTotalVO;
    }

    /**
     *获取原材料的期初库存数据
     *如果没有则查找日期<=当前日期的动态数据表取期末库存数据做为期初库存数据
     *如果没有查到则查原材料对应的期初库存数据做为期初库存数据
     * @param materialId 原材料id
     * @param date   日期
     * @return
     */
    public MaterialStartInventoryEntity getMaterialStartInventory(Long materialId,String date,Map<String,MaterialStartInventoryEntity> map){
        MaterialStartInventoryEntity materialStartInventoryEntity = map.get(materialId.toString());
        if (materialStartInventoryEntity == null){
            QueryWrapper<MaterialDynamicOutEntity> query = new QueryWrapper<>();
            query.eq("material_id",materialId)
                    .ne("date",date)
                    .orderByDesc("create_time");
            List<MaterialDynamicOutEntity> list = materialDynamicOutService.list(query);
            if (list.isEmpty()){
                QueryWrapper<MaterialStartInventoryEntity> query2 = new QueryWrapper<>();
                query2.eq("material_id",materialId)
                        .orderByDesc("create_time");
                List<MaterialStartInventoryEntity> list2 = materialStartInventoryService.list(query2);
                if (!list2.isEmpty()){
                    materialStartInventoryEntity = list2.get(0);
                }else {
                    logger.error("原材料未查询到的期初库存数据id = {}"+materialId);
                }
            }else {
                materialStartInventoryEntity = new MaterialStartInventoryEntity();
                MaterialDynamicOutEntity materialDynamicOutEntity = list.get(0);
                materialStartInventoryEntity.setMaterialId(materialDynamicOutEntity.getMaterialId());
                materialStartInventoryEntity.setInventoryAmount(materialDynamicOutEntity.getEndInventoryAmount());
                materialStartInventoryEntity.setMaterialAccount(materialDynamicOutEntity.getStartInventoryAccount());
                materialStartInventoryEntity.setInventoryUnitPrice(materialDynamicOutEntity.getEndInventoryPrice());
            }
        }
        return materialStartInventoryEntity;
    }
    /**
     * 计算加权平均单价
     * 先去获取本次程序中原材料对应的期初库存数据
     * 如果没有则查找日期<=当前日期的动态数据表取期末库存数据做为期初库存数据
     * 如果没有查到则查原材料对应的期初库存数据做为期初库存数据
     * @param materialId 原材料id
     * @param date   日期
     * @return
     */
    public BigDecimal calWeightedAverageUnitPrice(Long materialId,String date,Map<String,MaterialStartInventoryEntity> map,Long orgId){
        //数量总和
        BigDecimal accountSum = BigDecimal.ZERO;
        //金额总和
        BigDecimal amountSum = BigDecimal.ZERO;
        CommonResponse<AcceptanceVO> response = api.queryMaterialAcceptance(materialId.toString(), date, orgId.toString());
        if (response.getCode() == 0){
            AcceptanceVO data = response.getData();
            MaterialStartInventoryEntity materialStartInventoryEntity = this.getMaterialStartInventory(materialId, date,map);
            accountSum = accountSum.add(data.getAcceptanceQuantity()).add(materialStartInventoryEntity.getMaterialAccount());
            amountSum = amountSum.add(data.getAcceptanceQuantity()).add(materialStartInventoryEntity.getInventoryAmount());
        }
        BigDecimal price = amountSum.divide(accountSum,2,BigDecimal.ROUND_HALF_UP);
        return  price;
    }
}
