package com.ejianc.business.cost.service.impl;

import com.ejianc.business.cost.bean.DatasummarydetailEntity;
import com.ejianc.business.cost.bean.OldMaterialDetailEntity;
import com.ejianc.business.cost.mapper.OldMaterialDetailMapper;
import com.ejianc.business.cost.service.IOldMaterialDetailService;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.List;

/**
 * 旧料投放明细
 * 
 * @author generator
 * 
 */
@Service("oldMaterialDetailService")
public class OldMaterialDetailServiceImpl extends BaseServiceImpl<OldMaterialDetailMapper, OldMaterialDetailEntity> implements IOldMaterialDetailService {

    @Override
    public DatasummarydetailEntity calMaterialUse(List<OldMaterialDetailEntity> list, OldMaterialDetailEntity oldMaterialDetailEntity, BigDecimal count) {
        DatasummarydetailEntity datasummarydetailEntity=
                BeanMapper.map(oldMaterialDetailEntity,DatasummarydetailEntity.class);
        datasummarydetailEntity.setId(null);
        datasummarydetailEntity.setMid(null);
        //计算骨料的投放综合再计算每个骨料占总和的投放比例
        BigDecimal percentCount = new BigDecimal("0");

        for (OldMaterialDetailEntity Entity : list) {
            percentCount = percentCount.add(Entity.getMaterialThrowPercent());
        }

        BigDecimal percent = oldMaterialDetailEntity.getMaterialThrowPercent()
                .divide(percentCount,2, RoundingMode.HALF_UP);

        datasummarydetailEntity.setIsOldMaterial(1);
        datasummarydetailEntity.setMaterialUseTotal(count.multiply(percent));
        return datasummarydetailEntity;
    }
}
