package com.ejianc.business.cost.service.impl;

import com.ejianc.business.cost.bean.DatasummarydetailEntity;
import com.ejianc.business.cost.mapper.PowderDetailMapper;
import com.ejianc.business.cost.service.IPowderDetailService;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.cost.bean.PowderDetailEntity;

import java.math.BigDecimal;
import java.util.List;

/**
 * 粉料投放明细
 * 
 * @author generator
 * 
 */
@Service("powderDetailService")
public class PowderDetailServiceImpl extends BaseServiceImpl<PowderDetailMapper, PowderDetailEntity> implements IPowderDetailService {

    @Override
    public DatasummarydetailEntity calMaterialUse(List<PowderDetailEntity> list, PowderDetailEntity powderDetailEntity, BigDecimal count) {
        DatasummarydetailEntity datasummarydetailEntity=
                BeanMapper.map(powderDetailEntity,DatasummarydetailEntity.class);
        datasummarydetailEntity.setId(null);
        datasummarydetailEntity.setMid(null);
        //计算骨料的投放综合再计算每个骨料占总和的投放比例
        BigDecimal percentCount = new BigDecimal("0");
        for (PowderDetailEntity Entity : list) {
            percentCount = percentCount.add(Entity.getMaterialThrowPercent());
        }
        BigDecimal percent = powderDetailEntity.getMaterialThrowPercent()
                .divide(percentCount,2, BigDecimal.ROUND_HALF_UP);
        datasummarydetailEntity.setIsOldMaterial(0);
        datasummarydetailEntity.setMaterialUseTotal(count.multiply(percent));
        return datasummarydetailEntity;
    }
}
