package com.ejianc.business.cost.utils;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

/**
 * @authoer:禹鹏杰
 * @createDate:2022/9/22
 * @description:
 */
public class DateUtils {
    //格式转换
    private static SimpleDateFormat sf = new SimpleDateFormat("yyyy-MM-dd");

    /**
     * 获取日期的前一天
     * @param date 日期类型参数
     * @return String
     */
    public static String getDayAgo(Date date){
        //获取到当前日期
        Calendar calendar = Calendar.getInstance();
        //日期设置时间
        calendar.setTime(date);
        //给日期加一天
        calendar.add(Calendar.DATE,-1);
        //返回当前日期的前一天
        return sf.format(calendar.getTime());
    }

    /**
     * 获取开始时间相加n天的日期
     * @param date 开始时间
     * @param n    相加天数
     * @return    String
     */
    public static Date getAddDays(Date date,int n){
        //获取到当前日期
        Calendar calendar = Calendar.getInstance();
        //日期设置时间
        calendar.setTime(date);
        //给日期加一天
        calendar.add(Calendar.DATE,n);
        //返回当前日期的前一天
        return calendar.getTime();
    }
    /**
     * 获取两个日期之间相差的天数
     * @param startDate 较小的时间
     * @param endDate  较大的时间
     * @return 相差天数
     * @throws ParseException
     */
    public static int getDaysBetween(Date startDate,Date endDate) {
        Calendar cal = Calendar.getInstance();
        //日期设置时间
        cal.setTime(startDate);
        //获取开始时间毫秒数
        long startTime = cal.getTimeInMillis();
        //日期设置结束时间
        cal.setTime(endDate);
        //获取结束时间毫秒数
        long endTime = cal.getTimeInMillis();
        //计算得到两个时间相差毫秒数的天数
        long betweenDays=(endTime-startTime)/(1000*3600*24);
        //返回相差天数
        return Integer.parseInt(String.valueOf(betweenDays));
    }

    /**
     * 获取日期格式化字符串
     * @param date 日期类型参数
     * @return String
     */
    public static String getStringDate(Date date){
        return sf.format(date);
    }
    /**
     * 获取字符串格式化日期
     * @param date 日期类型参数
     * @return String
     */
    public static Date getDate(String date) throws ParseException {
        return sf.parse(date);
    }
}
