package com.ejianc.business.cost.vo;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import java.util.ArrayList;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 数据汇总
 * 
 * @author generator
 * 
 */
public class DatasummaryVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private String billCode; // 单据编号
    private Long productId; // 产品id
    private String productName; // 产品名称
    private Long unitId; // 机组id
    private String unitName; // 机组名称
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date productTime; // 生产日期
    private String productionMixtureName; // 生产配比名称
    private String productionMixtureProductName; // 生产配比产品名称
    private Long productionMixtureId; // 生产配比id
    private Long orgId; // 所属组织id
    private String orgName; // 所属组织名称
    private Integer billState; // 单据状态: 0自由态,1已提交,2审批中,3审批通过,4驳回,5提交后有人审批中
    private BigDecimal productionSum; // 产量

    private List<DatasummarydetailVO> datasummarydetailList = new ArrayList<>(); // 数据汇总明细表

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    @ReferSerialTransfer(referCode = "ProductRef")
    public Long getProductId() {
        return productId;
    }
    @ReferDeserialTransfer
    public void setProductId(Long productId) {
        this.productId = productId;
    }
    public String getProductName() {
        return productName;
    }

    public void setProductName(String productName) {
        this.productName = productName;
    }
    @ReferSerialTransfer(referCode = "UnitRef")
    public Long getUnitId() {
        return unitId;
    }
    @ReferDeserialTransfer
    public void setUnitId(Long unitId) {
        this.unitId = unitId;
    }
    public String getUnitName() {
        return unitName;
    }

    public void setUnitName(String unitName) {
        this.unitName = unitName;
    }
    public Date getProductTime() {
        return productTime;
    }

    public void setProductTime(Date productTime) {
        this.productTime = productTime;
    }
    public String getProductionMixtureName() {
        return productionMixtureName;
    }

    public void setProductionMixtureName(String productionMixtureName) {
        this.productionMixtureName = productionMixtureName;
    }
    public String getProductionMixtureProductName() {
        return productionMixtureProductName;
    }

    public void setProductionMixtureProductName(String productionMixtureProductName) {
        this.productionMixtureProductName = productionMixtureProductName;
    }
    @ReferSerialTransfer(referCode = "MixtureratioRef")
    public Long getProductionMixtureId() {
        return productionMixtureId;
    }
    @ReferDeserialTransfer
    public void setProductionMixtureId(Long productionMixtureId) {
        this.productionMixtureId = productionMixtureId;
    }
    @ReferSerialTransfer(referCode = "idm-org")
    public Long getOrgId() {
        return orgId;
    }
    @ReferDeserialTransfer
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    
     public List<DatasummarydetailVO> getDatasummarydetailList() {
        return datasummarydetailList;
     }

     public void setDatasummarydetailList(List<DatasummarydetailVO> datasummarydetailList) {
        this.datasummarydetailList = datasummarydetailList;
     }

    public BigDecimal getProductionSum() {
        return productionSum;
    }

    public void setProductionSum(BigDecimal productionSum) {
        this.productionSum = productionSum;
    }
}
