package com.ejianc.business.cost.vo;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.math.BigDecimal;
import java.util.Date;

/**
 * @authoer:禹鹏杰
 * @createDate:2022/10/12
 * @description:
 */
public class MaterialInventoryTransformVO {
    private Long materialId; // 原材料id
    private String materialName; // 原材料名称
    private Long categoryId; // 原材料类别id
    private String categoryName; // 原材料类别名称
    private Long materialVarietiesId; // 原材料品种id
    private String materialVarietiesName; // 原材料品种名称
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date inventoryDate; // 盘点日期
    private String position; // 库位
    private BigDecimal length; // 长
    private BigDecimal width; // 宽
    private BigDecimal height; // 高
    private BigDecimal cubic; // 立方
    private BigDecimal density; // 密度
    private BigDecimal materialAccount; // 盘点数量
    private Long orgId; // 组织id
    private String orgName; // 组织名称
    private String remark; // 备注

    @ReferSerialTransfer(referCode = "MaterialRef")
    public Long getMaterialId() {
        return materialId;
    }
    @ReferDeserialTransfer
    public void setMaterialId(Long materialId) {
        this.materialId = materialId;
    }
    public String getMaterialName() {
        return materialName;
    }

    public void setMaterialName(String materialName) {
        this.materialName = materialName;
    }
    @ReferSerialTransfer(referCode = "MaterialCategoryRef")
    public Long getCategoryId() {
        return categoryId;
    }
    @ReferDeserialTransfer
    public void setCategoryId(Long categoryId) {
        this.categoryId = categoryId;
    }
    public String getCategoryName() {
        return categoryName;
    }

    public void setCategoryName(String categoryName) {
        this.categoryName = categoryName;
    }
    @ReferSerialTransfer(referCode = "VarietiesaccountingRef")
    public Long getMaterialVarietiesId() {
        return materialVarietiesId;
    }
    @ReferDeserialTransfer
    public void setMaterialVarietiesId(Long materialVarietiesId) {
        this.materialVarietiesId = materialVarietiesId;
    }
    public String getMaterialVarietiesName() {
        return materialVarietiesName;
    }

    public void setMaterialVarietiesName(String materialVarietiesName) {
        this.materialVarietiesName = materialVarietiesName;
    }
    public String getPosition() {
        return position;
    }

    public void setPosition(String position) {
        this.position = position;
    }
    public BigDecimal getLength() {
        return length;
    }

    public void setLength(BigDecimal length) {
        this.length = length;
    }
    public BigDecimal getWidth() {
        return width;
    }

    public void setWidth(BigDecimal width) {
        this.width = width;
    }
    public BigDecimal getHeight() {
        return height;
    }

    public void setHeight(BigDecimal height) {
        this.height = height;
    }
    public BigDecimal getCubic() {
        return cubic;
    }

    public void setCubic(BigDecimal cubic) {
        this.cubic = cubic;
    }
    public BigDecimal getDensity() {
        return density;
    }

    public void setDensity(BigDecimal density) {
        this.density = density;
    }
    public BigDecimal getMaterialAccount() {
        return materialAccount;
    }

    public void setMaterialAccount(BigDecimal materialAccount) {
        this.materialAccount = materialAccount;
    }
    @ReferSerialTransfer(referCode = "idm-org")
    public Long getOrgId() {
        return orgId;
    }

    @ReferDeserialTransfer
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }


    public Date getInventoryDate() {
        return inventoryDate;
    }

    public void setInventoryDate(Date inventoryDate) {
        this.inventoryDate = inventoryDate;
    }
}
