package com.ejianc.business.cost.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.ejianc.business.cost.bean.MaterialUseDetailEntity;
import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;


/**
 * 原材料耗用表
 * 
 * @author generator
 * 
 */
public class MaterialUseVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private String billCode; // 单据编号
    private Long productId; // 产品id
    private String productName; // 产品名称
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date productTime; // 发货日期
    private String productionMixtureName; // 生产配比名称
    private Long productionMixtureId; // 生产配比id
    private Long orgId; // 所属组织id
    private String orgName; // 所属组织名称
    private Integer billState; // 单据状态: 0自由态,1已提交,2审批中,3审批通过,4驳回,5提交后有人审批中
    private BigDecimal netWeightSum; //发货数总和

    List<MaterialUseDetailVO> materialUseEntities = new ArrayList<>();


    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    @ReferSerialTransfer(referCode = "ProductRef")
    public Long getProductId() {
        return productId;
    }
    @ReferDeserialTransfer
    public void setProductId(Long productId) {
        this.productId = productId;
    }
    public String getProductName() {
        return productName;
    }

    public void setProductName(String productName) {
        this.productName = productName;
    }
    public Date getProductTime() {
        return productTime;
    }

    public void setProductTime(Date productTime) {
        this.productTime = productTime;
    }
    public String getProductionMixtureName() {
        return productionMixtureName;
    }

    public void setProductionMixtureName(String productionMixtureName) {
        this.productionMixtureName = productionMixtureName;
    }
    @ReferSerialTransfer(referCode = "ProductMixRef")
    public Long getProductionMixtureId() {
        return productionMixtureId;
    }
    @ReferDeserialTransfer
    public void setProductionMixtureId(Long productionMixtureId) {
        this.productionMixtureId = productionMixtureId;
    }
    @ReferSerialTransfer(referCode = "idm-org")
    public Long getOrgId() {
        return orgId;
    }
    @ReferDeserialTransfer
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }

    public List<MaterialUseDetailVO> getMaterialUseEntities() {
        return materialUseEntities;
    }

    public void setMaterialUseEntities(List<MaterialUseDetailVO> materialUseEntities) {
        this.materialUseEntities = materialUseEntities;
    }

    public BigDecimal getNetWeightSum() {
        return netWeightSum;
    }

    public void setNetWeightSum(BigDecimal netWeightSum) {
        this.netWeightSum = netWeightSum;
    }
}
