package com.ejianc.business.cost.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.ejianc.business.cost.bean.Aggregate7DetailEntity;
import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;

import com.ejianc.business.cost.vo.Aggregate7DetailVO;

/**
 * 成本结算
 * 
 * @author generator
 * 
 */
public class SettlementPeriodVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private String year; // 年度
    private Long orgId; // 所属组织id
    private Integer billState; // 单据状态: 0自由态,1已提交,2审批中,3审批通过,4驳回,5提交后有人审批中
    private String orgName; // 组织名称

    private List<SettlementPeriodDetailVO> settlementPeriodEntities = new ArrayList<>(); // 成本结算子表

    public String getYear() {
        return year;
    }

    public void setYear(String year) {
        this.year = year;
    }
    @ReferSerialTransfer(referCode = "idm-org")
    public Long getOrgId() {
        return orgId;
    }

    @ReferDeserialTransfer
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    public List<SettlementPeriodDetailVO> getSettlementPeriodEntities() {
        return settlementPeriodEntities;
    }

    public void setSettlementPeriodEntities(List<SettlementPeriodDetailVO> settlementPeriodEntities) {
        this.settlementPeriodEntities = settlementPeriodEntities;
    }
}
