/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.weigh.weighbill.controller.api;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.weigh.wagon.service.IWagonMaterialService;
import com.ejianc.business.weigh.wagon.vo.WagonMaterialVO;
import com.ejianc.business.weigh.weighbill.bean.WeighbillEntity;
import com.ejianc.business.weigh.weighbill.service.IWeighbillService;
import com.ejianc.business.weigh.weighbill.vo.WeighbillVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import io.swagger.annotations.ApiOperation;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/weighbill/"})
public class WeighbillApi {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IWeighbillService weighbillService;
    @Autowired
    private IWagonMaterialService wagonMaterialService;

    @ApiOperation(value="\u6839\u636e\u78c5\u5355\u4e3b\u952e\u8fd4\u56de\u8be6\u60c5\u63a5\u53e3")
    @RequestMapping(value={"/queryWeighbills"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<List<WeighbillVO>> queryWeighbills(@RequestParam(value="projectId") Long projectId, @RequestParam(value="weighIds") List<Long> weighIds) {
        this.logger.info("\u6839\u636e\u78c5\u5355\u4e3b\u952e\u8fd4\u56de\u8be6\u60c5\u63a5\u53e3\u53c2\u6570\uff1a{}", (Object)JSONObject.toJSONString(weighIds));
        List resList = new ArrayList();
        ArrayList<Long> materialIds = new ArrayList();
        List weighbillEntityList = this.weighbillService.list((Wrapper)new QueryWrapper().in((Object)"id", weighIds));
        if (CollectionUtils.isNotEmpty((Collection)weighbillEntityList)) {
            materialIds = weighbillEntityList.stream().map(WeighbillEntity::getMaterialId).collect(Collectors.toList());
            this.logger.info("-----\u53c2\u6570\uff1a{}", (Object)JSONObject.toJSONString(materialIds));
            resList = BeanMapper.mapList((Iterable)weighbillEntityList, WeighbillVO.class);
            List<WagonMaterialVO> wagonMaterialVOList = this.wagonMaterialService.queryMaterialAutomaticWeighBatch(projectId, materialIds);
            this.logger.info("\u67e5\u8be2\u78c5\u5355\u8f6c\u6362\u7cfb\u6570\u8fd4\u56de\u6570\u636e\uff1a{}", (Object)JSONObject.toJSONString(wagonMaterialVOList));
            HashMap<Long, BigDecimal> map = new HashMap<Long, BigDecimal>();
            if (CollectionUtils.isNotEmpty(wagonMaterialVOList)) {
                for (int k = 0; k < wagonMaterialVOList.size(); ++k) {
                    if (map.containsKey(wagonMaterialVOList.get(k).getMaterialId())) continue;
                    map.put(wagonMaterialVOList.get(k).getMaterialId(), wagonMaterialVOList.get(k).getScaleFactor());
                }
                for (int i = 0; i < resList.size(); ++i) {
                    WeighbillVO vo = (WeighbillVO)resList.get(i);
                    if (map.containsKey(vo.getMaterialId())) {
                        ((WeighbillVO)resList.get(i)).setCoefficient((BigDecimal)map.get(vo.getMaterialId()));
                        continue;
                    }
                    ((WeighbillVO)resList.get(i)).setCoefficient(BigDecimal.ZERO);
                }
            } else {
                resList.forEach(e -> e.setCoefficient(BigDecimal.ZERO));
            }
        }
        this.logger.info("\u6839\u636e\u78c5\u5355\u4e3b\u952e\u8fd4\u56de\u8be6\u60c5\u63a5\u53e3\u8fd4\u56de\u6570\u636e\uff1a{}", (Object)JSONObject.toJSONString(resList));
        return CommonResponse.success(resList);
    }

    @ApiOperation(value="\u6839\u636e\u53d1\u8d27\u5355\u4e3b\u952e\u8fd4\u56de\u8be6\u60c5\u63a5\u53e3")
    @RequestMapping(value={"/queryWeighBydeliveryId"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<List<WeighbillVO>> queryWeighBydeliveryId(@RequestParam(value="deliveryIds") List<Long> deliveryIds) {
        this.logger.info("\u6839\u636e\u78c5\u5355\u4e3b\u952e\u8fd4\u56de\u8be6\u60c5\u63a5\u53e3\u53c2\u6570\uff1a{}", (Object)JSONObject.toJSONString(deliveryIds));
        ArrayList resList = new ArrayList();
        List weighbillEntityList = this.weighbillService.list((Wrapper)new QueryWrapper().in((Object)"delivery_id", deliveryIds));
        HashMap<Long, Integer> weighMap = new HashMap<Long, Integer>();
        HashMap<Long, Integer> checkMap = new HashMap<Long, Integer>();
        if (CollectionUtils.isNotEmpty((Collection)weighbillEntityList)) {
            for (int i = 0; i < weighbillEntityList.size(); ++i) {
                WeighbillEntity weighbillEntity = (WeighbillEntity)((Object)weighbillEntityList.get(i));
                if (weighMap.containsKey(weighbillEntity.getDeliveryId())) {
                    weighMap.put(weighbillEntity.getDeliveryId(), (Integer)weighMap.get(weighbillEntity.getDeliveryId()) + 1);
                } else {
                    weighMap.put(weighbillEntity.getDeliveryId(), 1);
                }
                if (checkMap.containsKey(weighbillEntity.getDeliveryId())) {
                    if (1 != weighbillEntity.getCheckStatus()) continue;
                    checkMap.put(weighbillEntity.getDeliveryId(), (Integer)checkMap.get(weighbillEntity.getDeliveryId()) + 1);
                    continue;
                }
                if (1 != weighbillEntity.getCheckStatus()) continue;
                checkMap.put(weighbillEntity.getDeliveryId(), 1);
            }
        }
        deliveryIds.forEach(e -> {
            WeighbillVO weighbillVO = new WeighbillVO();
            weighbillVO.setDeliveryId(e);
            weighbillVO.setWeightNum(Integer.valueOf(weighMap.get(e) == null ? 0 : (Integer)weighMap.get(e)));
            weighbillVO.setWeightCheckNum(Integer.valueOf(checkMap.get(e) == null ? 0 : (Integer)checkMap.get(e)));
            resList.add(weighbillVO);
        });
        this.logger.info("\u6839\u636e\u78c5\u5355\u4e3b\u952e\u8fd4\u56de\u8be6\u60c5\u63a5\u53e3\u8fd4\u56de\u6570\u636e\uff1a{}", (Object)JSONObject.toJSONString(resList));
        return CommonResponse.success(resList);
    }

    @ApiOperation(value="\u66f4\u65b0\u78c5\u5355\u9a8c\u6536\u72b6\u6001")
    @RequestMapping(value={"/updateWeighbills"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> updateWeighbills(@RequestBody List<WeighbillVO> weighbillVOList) {
        this.logger.info("\u66f4\u65b0\u78c5\u5355\u9a8c\u6536\u72b6\u6001\u63a5\u53e3\u53c2\u6570\uff1a{}", (Object)JSONObject.toJSONString(weighbillVOList));
        if (CollectionUtils.isNotEmpty(weighbillVOList)) {
            ArrayList list = new ArrayList();
            weighbillVOList.forEach(e -> {
                WeighbillEntity weighbillEntity = (WeighbillEntity)((Object)((Object)this.weighbillService.selectById(e.getId())));
                weighbillEntity.setCheckStatus(e.getCheckStatus());
                weighbillEntity.setCheckId(e.getCheckId());
                weighbillEntity.setCheckDetailId(e.getCheckDetailId());
                list.add(weighbillEntity);
            });
            this.weighbillService.updateBatchById(list);
            this.logger.info("\u66f4\u65b0\u78c5\u5355\u9a8c\u6536\u72b6\u6001\u8fd4\u56de\u6570\u636e\uff1a{}", (Object)JSONObject.toJSONString(list));
        }
        return CommonResponse.success((String)"\u6267\u884c\u6210\u529f");
    }
}

