/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.weigh.weighbill.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.weigh.weighbill.bean.WeighbillEntity;
import com.ejianc.business.weigh.weighbill.gldVo.GLDErrorVO;
import com.ejianc.business.weigh.weighbill.gldVo.PushGLDErrorVO;
import com.ejianc.business.weigh.weighbill.gldVo.PushGLDOrderDetailVO;
import com.ejianc.business.weigh.weighbill.gldVo.PushGLDOrderVO;
import com.ejianc.business.weigh.weighbill.gldVo.PushGLDWayBillDetailVO;
import com.ejianc.business.weigh.weighbill.gldVo.PushGLDWayBillVO;
import com.ejianc.business.weigh.weighbill.mapper.WeighbillMapper;
import com.ejianc.business.weigh.weighbill.service.IPushDataToThirdService;
import com.ejianc.business.weigh.weighbill.vo.DeliveryThirdVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.glodon.cloudt.rest.client.RestServiceClient;
import com.glodon.cloudt.rest.client.data.HmacRestAuthInfo;
import com.glodon.cloudt.rest.client.data.RestAuthInfo;
import com.glodon.cloudt.rest.client.data.RestResponseInfo;
import com.glodon.cloudt.rest.client.exception.AuthenticateException;
import com.glodon.cloudt.rest.client.exception.InvalidUriException;
import com.glodon.cloudt.rest.client.exception.NoAuthenticateException;
import com.glodon.cloudt.rest.client.impl.HmacRestServiceClient;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.ClassPathResource;
import org.springframework.stereotype.Service;

@Service(value="pushDataToGLDService")
public class PushDataToGLDServiceImpl
extends BaseServiceImpl<WeighbillMapper, WeighbillEntity>
implements IPushDataToThirdService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String API_URL_ORDER = "/gys/material-track/order/batchSave";
    private static final String API_URL_WAYBILL = "/gys/gems-web-api/waybillApi/batchSaveWaybills";
    @Value(value="${common.env.base-host}")
    private String BaseHost;

    @Override
    public CommonResponse<String> pushDataToThird(DeliveryThirdVO deliveryThirdVO) {
        this.logger.info("\u63a8\u9001GLD\u8ba2\u5355\u6570\u636e\u5165\u53c2\uff1a{}", (Object)JSONObject.toJSONString((Object)deliveryThirdVO));
        CommonResponse<String> orderRes = this.pushOrder(deliveryThirdVO);
        if (!orderRes.isSuccess()) {
            return CommonResponse.error((String)orderRes.getMsg());
        }
        CommonResponse<String> wayBillRes = this.pushWayBill(deliveryThirdVO);
        if (!wayBillRes.isSuccess()) {
            return CommonResponse.error((String)wayBillRes.getMsg());
        }
        return CommonResponse.success((String)"\u63a8\u9001\u6210\u529f");
    }

    public CommonResponse<String> pushOrder(DeliveryThirdVO deliveryThirdVO) {
        block10: {
            try {
                RestServiceClient serviceClient = HmacRestServiceClient.getInstance();
                HmacRestAuthInfo restAuthInfo = new HmacRestAuthInfo();
                String authInfoPath = "";
                if (this.BaseHost.contains("https://pm.ynsbj.com/")) {
                    authInfoPath = "authFileProd/auth.lic";
                    this.logger.info("\u83b7\u53d6\u6388\u6743\u6587\u4ef6-----\uff1a{}", (Object)authInfoPath);
                } else {
                    authInfoPath = "authFileTest/auth.lic";
                    this.logger.info("\u83b7\u53d6\u6388\u6743\u6587\u4ef6-----\uff1a{}", (Object)authInfoPath);
                }
                ClassPathResource resource = new ClassPathResource(authInfoPath);
                restAuthInfo.setLicStream(resource.getInputStream());
                serviceClient.authenticate((RestAuthInfo)restAuthInfo);
                String hostAddress = serviceClient.getRestRootAddress();
                String orderURL = hostAddress + API_URL_ORDER;
                PushGLDOrderVO orderVO = this.changeOrderVo(deliveryThirdVO);
                ArrayList<PushGLDOrderVO> list = new ArrayList<PushGLDOrderVO>();
                list.add(orderVO);
                this.logger.info("\u63a8\u9001GLD\u8ba2\u5355\u6570\u636eURL\uff1a{}", (Object)orderURL);
                this.logger.info("\u63a8\u9001GLD\u8ba2\u5355\u6570\u636e\u53c2\u6570\u53c2\u6570\uff1a{}", (Object)JSONObject.toJSONString(list));
                RestResponseInfo restResponseInfo = serviceClient.post(orderURL, JSONObject.toJSONString(list));
                if (restResponseInfo.isSuccess()) {
                    this.logger.info("GLD\u8ba2\u5355\u8fd4\u56de\u6570\u636e--\uff1a{}", (Object)restResponseInfo.getStringContent());
                    PushGLDErrorVO pushGLDErrorVO = (PushGLDErrorVO)JSONObject.parseObject((String)restResponseInfo.getStringContent(), PushGLDErrorVO.class);
                    if (500 == pushGLDErrorVO.getCode()) {
                        return CommonResponse.error((String)("\u63a8\u9001\u5e7f\u8054\u8fbe\u8ba2\u5355\u63a5\u53e3\u5f02\u5e38,\u5f02\u5e38\u4fe1\u606f\uff1a" + pushGLDErrorVO.getMessage()));
                    }
                    if (CollectionUtils.isNotEmpty((Collection)pushGLDErrorVO.getData().getErrorList())) {
                        return CommonResponse.error((String)("\u63a8\u9001\u5e7f\u8054\u8fbe\u8ba2\u5355\u63a5\u53e3\u5f02\u5e38\uff01,\u5f02\u5e38\u4fe1\u606f\uff1a" + ((GLDErrorVO)pushGLDErrorVO.getData().getErrorList().get(0)).getErrMsg()));
                    }
                    break block10;
                }
                String faultLogApiURI = "/gys/tl/services/trace/api-fault-log";
                String faultLogFullURL = hostAddress + faultLogApiURI;
                JSONObject faultLog = new JSONObject();
                faultLog.put("requestUrl", (Object)orderURL);
                faultLog.put("requestMethod", (Object)"POST");
                faultLog.put("requestBody", (Object)"");
                faultLog.put("statusCode", (Object)restResponseInfo.getErrorCode());
                faultLog.put("response", (Object)restResponseInfo.getStringContent());
                faultLog.put("description", (Object)restResponseInfo.getErrorMessage());
                DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyyMMddHHmmss");
                LocalDateTime dateTime = LocalDateTime.now();
                String searchKey = formatter.format(dateTime);
                faultLog.put("searchKey", (Object)searchKey);
                serviceClient.post(faultLogFullURL, faultLog.toJSONString());
                return CommonResponse.error((String)("\u63a8\u9001\u5e7f\u8054\u8fbe\u8ba2\u5355\u63a5\u53e3\u5f02\u5e38,\u5f02\u5e38\u4fe1\u606f\uff1a" + restResponseInfo.getErrorMessage()));
            }
            catch (AuthenticateException e) {
                e.printStackTrace();
                return CommonResponse.error((String)("\u63a8\u9001\u5e7f\u8054\u8fbe\u8ba2\u5355\u63a5\u53e3\u5f02\u5e38,\u5f02\u5e38\u4fe1\u606f\uff1a" + e.getMessage()));
            }
            catch (InvalidUriException e) {
                e.printStackTrace();
                return CommonResponse.error((String)("\u63a8\u9001\u5e7f\u8054\u8fbe\u8ba2\u5355\u63a5\u53e3\u5f02\u5e38,\u5f02\u5e38\u4fe1\u606f\uff1a" + e.getMessage()));
            }
            catch (NoAuthenticateException e) {
                e.printStackTrace();
                return CommonResponse.error((String)("\u63a8\u9001\u5e7f\u8054\u8fbe\u8ba2\u5355\u63a5\u53e3\u5f02\u5e38,\u5f02\u5e38\u4fe1\u606f\uff1a" + e.getMessage()));
            }
            catch (IOException e) {
                e.printStackTrace();
                return CommonResponse.error((String)("\u63a8\u9001\u5e7f\u8054\u8fbe\u8ba2\u5355\u63a5\u53e3\u5f02\u5e38,\u5f02\u5e38\u4fe1\u606f\uff1a" + e.getMessage()));
            }
        }
        return CommonResponse.success((String)"\u63a8\u9001\u8ba2\u5355\u6210\u529f");
    }

    public CommonResponse<String> pushWayBill(DeliveryThirdVO deliveryThirdVO) {
        block8: {
            try {
                RestServiceClient serviceClient = HmacRestServiceClient.getInstance();
                HmacRestAuthInfo restAuthInfo = new HmacRestAuthInfo();
                String authInfoPath = "";
                authInfoPath = this.BaseHost.contains("https://pm.ynsbj.com/") ? "authFileProd/auth.lic" : "authFileTest/auth.lic";
                ClassPathResource resource = new ClassPathResource(authInfoPath);
                restAuthInfo.setLicStream(resource.getInputStream());
                serviceClient.authenticate((RestAuthInfo)restAuthInfo);
                String hostAddress = serviceClient.getRestRootAddress();
                String orderURL = hostAddress + API_URL_WAYBILL;
                PushGLDWayBillVO wayBillVO = this.changeWayBillVo(deliveryThirdVO);
                ArrayList<PushGLDWayBillVO> list = new ArrayList<PushGLDWayBillVO>();
                list.add(wayBillVO);
                this.logger.info("\u63a8\u9001GLD\u8fd0\u5355\u6570\u636eURL\uff1a{}", (Object)orderURL);
                this.logger.info("\u63a8\u9001GLD\u8fd0\u5355\u6570\u636e\u53c2\u6570\u53c2\u6570\uff1a{}", (Object)JSONObject.toJSONString(list));
                RestResponseInfo restResponseInfo = serviceClient.post(orderURL, JSONObject.toJSONString(list));
                if (restResponseInfo.isSuccess()) {
                    this.logger.info("GLD\u8fd0\u5355\u8fd4\u56de\u6570\u636e--\uff1a{}", (Object)restResponseInfo.getStringContent());
                    PushGLDErrorVO pushGLDErrorVO = (PushGLDErrorVO)JSONObject.parseObject((String)restResponseInfo.getStringContent(), PushGLDErrorVO.class);
                    if (500 == pushGLDErrorVO.getCode()) {
                        return CommonResponse.error((String)("\u63a8\u9001\u5e7f\u8054\u8fbe\u8fd0\u5355\u63a5\u53e3\u5f02\u5e38,\u5f02\u5e38\u4fe1\u606f\uff1a" + pushGLDErrorVO.getMessage()));
                    }
                    if (CollectionUtils.isNotEmpty((Collection)pushGLDErrorVO.getData().getErrorList())) {
                        return CommonResponse.error((String)("\u63a8\u9001\u5e7f\u8054\u8fbe\u8fd0\u5355\u63a5\u53e3\u5f02\u5e38\uff01,\u5f02\u5e38\u4fe1\u606f\uff1a" + ((GLDErrorVO)pushGLDErrorVO.getData().getErrorList().get(0)).getErrMsg()));
                    }
                    break block8;
                }
                String faultLogApiURI = "/gys/tl/services/trace/api-fault-log";
                String faultLogFullURL = hostAddress + faultLogApiURI;
                JSONObject faultLog = new JSONObject();
                faultLog.put("requestUrl", (Object)orderURL);
                faultLog.put("requestMethod", (Object)"POST");
                faultLog.put("requestBody", (Object)"");
                faultLog.put("statusCode", (Object)restResponseInfo.getErrorCode());
                faultLog.put("response", (Object)restResponseInfo.getStringContent());
                faultLog.put("description", (Object)restResponseInfo.getErrorMessage());
                DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyyMMddHHmmss");
                LocalDateTime dateTime = LocalDateTime.now();
                String searchKey = formatter.format(dateTime);
                faultLog.put("searchKey", (Object)searchKey);
                serviceClient.post(faultLogFullURL, faultLog.toJSONString());
                return CommonResponse.error((String)("\u63a8\u9001\u5e7f\u8054\u8fbe\u8fd0\u5355\u63a5\u53e3\u5f02\u5e38,\u5f02\u5e38\u4fe1\u606f\uff1a" + restResponseInfo.getErrorMessage()));
            }
            catch (AuthenticateException e) {
                e.printStackTrace();
                return CommonResponse.error((String)("\u63a8\u9001\u5e7f\u8054\u8fbe\u8fd0\u5355\u63a5\u53e3\u5f02\u5e38,\u5f02\u5e38\u4fe1\u606f\uff1a" + e.getMessage()));
            }
            catch (InvalidUriException e) {
                e.printStackTrace();
                return CommonResponse.error((String)("\u63a8\u9001\u5e7f\u8054\u8fbe\u8fd0\u5355\u63a5\u53e3\u5f02\u5e38,\u5f02\u5e38\u4fe1\u606f\uff1a" + e.getMessage()));
            }
            catch (NoAuthenticateException e) {
                e.printStackTrace();
                return CommonResponse.error((String)("\u63a8\u9001\u5e7f\u8054\u8fbe\u8fd0\u5355\u63a5\u53e3\u5f02\u5e38,\u5f02\u5e38\u4fe1\u606f\uff1a" + e.getMessage()));
            }
            catch (IOException e) {
                e.printStackTrace();
                return CommonResponse.error((String)("\u63a8\u9001\u5e7f\u8054\u8fbe\u8ba2\u5355\u63a5\u53e3\u5f02\u5e38,\u5f02\u5e38\u4fe1\u606f\uff1a" + e.getMessage()));
            }
        }
        return CommonResponse.success((String)"\u63a8\u9001\u8fd0\u5355\u6210\u529f");
    }

    public PushGLDOrderVO changeOrderVo(DeliveryThirdVO deliveryThirdVO) {
        PushGLDOrderVO pushGLDOrderVO = new PushGLDOrderVO();
        pushGLDOrderVO.setUnitId(deliveryThirdVO.getId().toString());
        pushGLDOrderVO.setSyncCode(deliveryThirdVO.getSyncCode());
        pushGLDOrderVO.setOrderNum(deliveryThirdVO.getBillCode());
        pushGLDOrderVO.setProviderUnitId(deliveryThirdVO.getSupplierId().toString());
        pushGLDOrderVO.setProviderName(deliveryThirdVO.getSupplierName());
        pushGLDOrderVO.setCreater(deliveryThirdVO.getEmployeeName() == null ? deliveryThirdVO.getCreateUserCode() : deliveryThirdVO.getEmployeeName());
        pushGLDOrderVO.setProjectName(deliveryThirdVO.getCustomerName());
        pushGLDOrderVO.setAddress(deliveryThirdVO.getOrderAddress());
        pushGLDOrderVO.setOptFlag(Integer.valueOf(0));
        List detailList = deliveryThirdVO.getDetailList();
        if (CollectionUtils.isNotEmpty((Collection)detailList)) {
            ArrayList orderMaterials = new ArrayList();
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            detailList.forEach(e -> {
                PushGLDOrderDetailVO pushGLDOrderDetailVO = new PushGLDOrderDetailVO();
                pushGLDOrderDetailVO.setUnitId(deliveryThirdVO.getDeliverType() + "&" + e.getId().toString());
                pushGLDOrderDetailVO.setUnitPid(e.getDeliveryId().toString());
                pushGLDOrderDetailVO.setMaterialUnitId(e.getMaterialId().toString());
                pushGLDOrderDetailVO.setMaterialCode(e.getMaterialCode().toString());
                pushGLDOrderDetailVO.setMaterialName(e.getMaterialName().toString());
                pushGLDOrderDetailVO.setUnit(e.getUnit());
                pushGLDOrderDetailVO.setSpecification(e.getSpec());
                pushGLDOrderDetailVO.setOrderQuantity(e.getDeliveryNum());
                pushGLDOrderDetailVO.setIncomeDate(simpleDateFormat.format(deliveryThirdVO.getArriveDate()));
                orderMaterials.add(pushGLDOrderDetailVO);
            });
            pushGLDOrderVO.setOrderMaterials(orderMaterials);
        }
        return pushGLDOrderVO;
    }

    public PushGLDWayBillVO changeWayBillVo(DeliveryThirdVO deliveryThirdVO) {
        PushGLDWayBillVO pushGLDWayBillVO = new PushGLDWayBillVO();
        pushGLDWayBillVO.setUnitId(deliveryThirdVO.getId().toString());
        pushGLDWayBillVO.setSyncCode(deliveryThirdVO.getSyncCode());
        pushGLDWayBillVO.setWaybillNum(deliveryThirdVO.getBillCode());
        pushGLDWayBillVO.setProviderUnitId(deliveryThirdVO.getSupplierId().toString());
        pushGLDWayBillVO.setCarNum(deliveryThirdVO.getLicensePlate() == null ? "\u4eacA00000" : deliveryThirdVO.getLicensePlate());
        pushGLDWayBillVO.setOrderUnitId(deliveryThirdVO.getId().toString());
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        pushGLDWayBillVO.setWaybillSubmitTime(simpleDateFormat.format(deliveryThirdVO.getArriveDate()));
        pushGLDWayBillVO.setStatus(Integer.valueOf(1));
        pushGLDWayBillVO.setAddress(deliveryThirdVO.getOrderAddress());
        pushGLDWayBillVO.setOptFlag(Integer.valueOf(0));
        List detailList = deliveryThirdVO.getDetailList();
        if (CollectionUtils.isNotEmpty((Collection)detailList)) {
            ArrayList waybillMaterials = new ArrayList();
            detailList.forEach(e -> {
                PushGLDWayBillDetailVO pushGLDWayBillDetailVO = new PushGLDWayBillDetailVO();
                pushGLDWayBillDetailVO.setUnitId(deliveryThirdVO.getDeliverType() + "&" + e.getId().toString());
                pushGLDWayBillDetailVO.setUnitPid(e.getDeliveryId().toString());
                pushGLDWayBillDetailVO.setMaterialUnitId(e.getMaterialId().toString());
                pushGLDWayBillDetailVO.setMaterialCode(e.getMaterialCode().toString());
                pushGLDWayBillDetailVO.setMaterialName(e.getMaterialName().toString());
                pushGLDWayBillDetailVO.setUnit(e.getUnit());
                pushGLDWayBillDetailVO.setSpecification(e.getSpec());
                pushGLDWayBillDetailVO.setWayBillQuantity(e.getDeliveryNum());
                waybillMaterials.add(pushGLDWayBillDetailVO);
            });
            pushGLDWayBillVO.setWaybillMaterials(waybillMaterials);
        }
        return pushGLDWayBillVO;
    }
}

