package com.ejianc.business.weigh.weighbill.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.weigh.weighbill.bean.WeighbillEntity;
import com.ejianc.business.weigh.weighbill.bean.WeighbillImgEntity;
import com.ejianc.business.weigh.weighbill.mapper.WeighbillMapper;
import com.ejianc.business.weigh.weighbill.service.IWeighbillImgService;
import com.ejianc.business.weigh.weighbill.service.IWeighbillService;
import com.ejianc.business.weigh.weighbill.vo.DelWeighbillVO;
import com.ejianc.business.weigh.weighbill.vo.PushWeighbillVO;
import com.ejianc.business.weigh.weighbill.vo.WeighbillImgsVO;
import com.ejianc.business.wzxt.api.IOrderApi;
import com.ejianc.business.wzxt.vo.OrderDetailVO;
import com.ejianc.business.wzxt.vo.OrderVO;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.file.vo.AttachmentRequestVO;
import com.ejianc.foundation.file.vo.UploadFileForNetParam;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.*;

/**
 * 磅单实体
 * 
 * @author generator
 * 
 */
@Service("weighbillService")
public class WeighbillServiceImpl extends BaseServiceImpl<WeighbillMapper, WeighbillEntity> implements IWeighbillService {

    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillCodeApi billCodeApi;

    private static final String BILL_CODE = "BDCODE";//此处需要根据实际修改

    private static final String BILL_TYPE = "EJCBT202308000001";//单据类型

    private final String[] ALLOW_WEIGH_UNIT = new String[]{"千克", "公斤", "KG", "kg", "Kg", "T", "t", "吨"};

    private static final String PZ_SOURCETYPE = "pz_image";//皮重
    private static final String MZ_SOURCETYPE = "mz_image";//毛重

    @Autowired
    private IOrderApi orderApi;

    @Autowired
    private IWeighbillImgService weighbillImgService;

    @Autowired
    private IAttachmentApi attachmentApi;
    @Override
    public CommonResponse<String> saveWeigh(PushWeighbillVO weighVO) {
        long startTime1 = System.currentTimeMillis();
        logger.info("第三方调用开始，参数：{}", JSONObject.toJSONString(weighVO));
        //1,查询数据库是否存在
            // 存在：
                   //  看是否被验收
                        //已被验收  则提示
                        //未被验收  则先删除，后新增
           //不存在  直接新增
                 //新增校验  数据合法性
        String sourceId = weighVO.getPmId();
        //todo 物料明细主键拆分
//        sourceId  = xx(混凝土HNT/消耗材CL)&xxxxxx(发货单明细主键)&xxxxx(物料明细)
        String[] ids = sourceId.split("&");
        String type = "";
        String detailId = "";
        String wlId = "";
        if(!"".equals(ids)&&ids.length>0){
            type = ids[0];
            detailId = ids[1];
            if(ids.length>2){
                wlId = ids[3];
            }
        }
        // check单位合法性
        Set<String> set = new HashSet<>(Arrays.asList(ALLOW_WEIGH_UNIT));
        if (!set.contains(weighVO.getWeightUnit())) {
            return CommonResponse.error("重量单位不合法!");
        }
        //todo 获取 验收主表数据
        OrderVO orderVO = new OrderVO();
        if("CL".equals(type)){
            logger.info("查询订单，参数：{}", detailId);
            CommonResponse<OrderVO> commonResponse =  orderApi.queryOrderByDetailId(Long.valueOf(detailId));
            if(!commonResponse.isSuccess()){
                logger.info("查询订单，返回：{}", commonResponse.getMsg());
                return CommonResponse.error("PM查询数据异常,数据推送失败!");
            }
            orderVO = commonResponse.getData();
        }
        long endTime1 = System.currentTimeMillis();
        logger.info("第一个运行时间为：" + (endTime1 - startTime1) + "ms");
        if(null !=orderVO && null!=orderVO.getPurchaseOrderDetail() && orderVO.getPurchaseOrderDetail().size()>0){
        }else{
            return CommonResponse.error("PM系统未查询到材料信息,请确认数据参数合法性!");
        }
        WeighbillEntity weighEntityDB = super.getOne(new QueryWrapper<WeighbillEntity>().eq("third_weigh_id",weighVO.getThirdWeighId()).eq("source_system",weighVO.getSourceSystem()));
        if(null!=weighEntityDB){
          if(null!=weighEntityDB.getCheckId()){
              //说明已被验收引用
              return CommonResponse.error("该数据PM系统已被验收,不允许此操作!");
          }else{
              super.removeById(weighEntityDB.getId());
          }
        }
        long endTime2 = System.currentTimeMillis();
        logger.info("第二个运行时间为：" + (endTime2 - endTime1) + "ms");
        WeighbillEntity weighEntity =  BeanMapper.map(weighVO,WeighbillEntity.class);
        if(StringUtils.isEmpty(weighVO.getWeightCode())){
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE, InvocationInfoProxy.getTenantid(),weighVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
                weighEntity.setWeightCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                logger.info("网络异常， 编码生成失败， 请稍后再试");
                return CommonResponse.error("PM生成磅单编号异常,数据推送失败!");
            }
        }
        weighEntity = changeVo(weighEntity,orderVO,weighVO);
        super.saveOrUpdate(weighEntity,false);
        //上传附件到平台
        weighVO.setId(weighEntity.getId());
        long endTime3 = System.currentTimeMillis();
        logger.info("第三个运行时间为：" + (endTime3 - endTime2) + "ms");
        uploadImg(weighVO);
        long endTime4 = System.currentTimeMillis();
        logger.info("第四个运行时间为：" + (endTime4 - endTime3) + "ms");
        //处理子表
        uploadDetailImg(weighVO);
        long endTime5 = System.currentTimeMillis();
        logger.info("第五个运行时间为：" + (endTime5 - endTime4) + "ms");
        logger.info("总的运行时间为：" + (endTime5 - startTime1) + "ms");
        return CommonResponse.success("数据推送成功");
    }

    @Override
    public CommonResponse<String> deleteWeigh(DelWeighbillVO weighVO) {
        logger.info("第三方调用开始，参数：{}", JSONObject.toJSONString(weighVO));
        WeighbillEntity weighEntity = super.getOne(new QueryWrapper<WeighbillEntity>().eq("third_weigh_id",weighVO.getThirdWeighId()).eq("source_system",weighVO.getSourceSystem()));
        if(null==weighEntity){
            return CommonResponse.error("该数据在PM系统未被查询到,请刷新后重试!");
        }
        if(null!=weighEntity&&null!=weighEntity.getCheckId()){
            return CommonResponse.error("该数据PM系统已被验收,不允许此操作!");
        }
        super.removeById(weighEntity.getId());
        return CommonResponse.success("数据删除成功");
    }

    @Override
    public CommonResponse<String> saveWeighImgs(PushWeighbillVO weighVO) {
        long startTime1 = System.currentTimeMillis();
        logger.info("第三方调用开始，参数：{}", JSONObject.toJSONString(weighVO));
        WeighbillEntity weighEntity = super.getOne(new QueryWrapper<WeighbillEntity>().eq("third_weigh_id",weighVO.getThirdWeighId()).eq("source_system",weighVO.getSourceSystem()));
        //先删除原图片
        weighbillImgService.remove(new QueryWrapper<WeighbillImgEntity>().eq("weight_id",weighEntity.getId()));
        long endTime1 = System.currentTimeMillis();
        logger.info("第一个运行时间为：" + (endTime1 - startTime1) + "ms");
        weighVO.setId(weighEntity.getId());
        //上传附件到平台
        weighVO.setId(weighEntity.getId());
        uploadImg(weighVO);
        long endTime2 = System.currentTimeMillis();
        logger.info("第二个运行时间为：" + (endTime2 - endTime1) + "ms");
        //处理子表
        uploadDetailImg(weighVO);
        long endTime3 = System.currentTimeMillis();
        logger.info("第三个运行时间为：" + (endTime3 - endTime2) + "ms");
        logger.info("程序总运行时间为：" + (endTime3 - startTime1) + "ms");
        return CommonResponse.success("同步磅单图片成功");
    }

    public WeighbillEntity changeVo(WeighbillEntity weighEntity, OrderVO orderVO,PushWeighbillVO weighVO){
        weighEntity.setDeliveryCode(orderVO.getBillCode());
        weighEntity.setProjectId(orderVO.getProjectId());
//        weighEntity.setProjectCode(orderVO.getProjectCode());
        weighEntity.setProjectName(orderVO.getProjectName());
        weighEntity.setOrgId(orderVO.getOrgId());
        weighEntity.setOrgName(orderVO.getOrgName());
//        weighEntity.setParentOrgId(orderVO.getParentOrgId());
//        weighEntity.setParentOrgName(orderVO.getParentOrgName());
//        weighEntity.setContractId(orderVO.getContractId());
//        weighEntity.setContractCode(orderVO.getContractCode());
        weighEntity.setContractName(orderVO.getContractName());
        weighEntity.setSupplierId(orderVO.getSupplierId());
        weighEntity.setSupplierName(orderVO.getSupplierName());
        List<OrderDetailVO> orderDetailList = orderVO.getPurchaseOrderDetail();
        OrderDetailVO orderDetailVO = orderDetailList.get(0);
        weighEntity.setDeliveryId(orderDetailVO.getOrderId());
        weighEntity.setDeliveryDetailId(orderDetailVO.getId());
        weighEntity.setMaterialTypeId(orderDetailVO.getMaterialTypeId());
        weighEntity.setMaterialTypeName(orderDetailVO.getMaterialTypeName());
        weighEntity.setMaterialId(orderDetailVO.getMaterialId());
        weighEntity.setMaterialCode(orderDetailVO.getMaterialCode());
        weighEntity.setMaterialName(orderDetailVO.getMaterialName());
        weighEntity.setSpec(orderDetailVO.getSpec());
        weighEntity.setUnit(orderDetailVO.getUnit());
//        weighEntity.setUnitId(orderDetailVO.getUnitId());
        weighEntity.setWeightDate(new Date());
        weighEntity.setCheckStatus(0);
        weighEntity.setGrossTime(new Date(weighVO.getGrossTime()));
        weighEntity.setTareTime(new Date(weighVO.getTareTime()));
        return weighEntity;
    }

    public String uploadImg(PushWeighbillVO weighbillVO){
        List<WeighbillImgsVO> imgVOList = weighbillVO.getWeighImgs();
        if(CollectionUtils.isNotEmpty(imgVOList)){
            List<String> mzListBase64 = new ArrayList<>();
            List<String> mzList = new ArrayList<>();
            List<String> pzListBase64 = new ArrayList<>();
            List<String> pzList = new ArrayList<>();
            imgVOList.forEach(e->{
               if(1 == e.getImageType()){
                //毛重图片
                   if(StringUtils.isNotEmpty(e.getImageBase64())){
                       mzListBase64.add(e.getImageBase64());
                   }else if(StringUtils.isNotEmpty(e.getImagePath())){
                       mzList.add(e.getImagePath());
                   }
               }else if(2 == e.getImageType()){
                   //皮重图片
                   if(StringUtils.isNotEmpty(e.getImageBase64())){
                       pzListBase64.add(e.getImageBase64());
                   }else if(StringUtils.isNotEmpty(e.getImagePath())){
                       pzList.add(e.getImagePath());
                   }
               }
            });
            //base64处理
            if(CollectionUtils.isNotEmpty(mzListBase64)){
                long startTimeImag = System.currentTimeMillis();
                AttachmentRequestVO attachmentVO = new AttachmentRequestVO();
                attachmentVO.setBillType(BILL_TYPE);
                attachmentVO.setSourceId(weighbillVO.getId().toString());
                attachmentVO.setSourceType(MZ_SOURCETYPE);
                attachmentVO.setHandleImg(false);
                attachmentVO.setClearBeforeSave(false);
                attachmentVO.setFileList(mzListBase64);
                attachmentApi.uploadForBase64(attachmentVO);
                long endTimeImag = System.currentTimeMillis();
                logger.info("上传一个MZ图片运行时间为：" + (endTimeImag - startTimeImag) + "ms");
            }

            if(CollectionUtils.isNotEmpty(pzListBase64)){
                long startTimeImag = System.currentTimeMillis();
                AttachmentRequestVO attachmentVO = new AttachmentRequestVO();
                attachmentVO.setBillType(BILL_TYPE);
                attachmentVO.setSourceId(weighbillVO.getId().toString());
                attachmentVO.setSourceType(PZ_SOURCETYPE);
                attachmentVO.setHandleImg(false);
                attachmentVO.setClearBeforeSave(false);
                attachmentVO.setFileList(pzListBase64);
                attachmentApi.uploadForBase64(attachmentVO);
                long endTimeImag = System.currentTimeMillis();
                logger.info("上传一个PZ图片运行时间为：" + (endTimeImag - startTimeImag) + "ms");
            }

            //地址处理
            if(CollectionUtils.isNotEmpty(mzList)){
                long startTimeImag = System.currentTimeMillis();
                UploadFileForNetParam param = new UploadFileForNetParam();
                param.setTenantId(999999L);
                param.setBillType(BILL_TYPE);
                param.setSourceId(weighbillVO.getId());
                param.setSourceType(MZ_SOURCETYPE);
                param.setFilePathList(mzList);
                logger.info("MZ参数：" +JSONObject.toJSONString(param));
                CommonResponse<String> mzRes = attachmentApi.uploadFileFormNet(param);
                long endTimeImag = System.currentTimeMillis();
                logger.info("上传MZ图片运行时间为：" + (endTimeImag - startTimeImag) + "ms");
                logger.info("MZ返回结果：" +mzRes.getData());
            }


            if(CollectionUtils.isNotEmpty(pzList)){
                UploadFileForNetParam param = new UploadFileForNetParam();
                param.setTenantId(999999L);
                param.setBillType(BILL_TYPE);
                param.setSourceId(weighbillVO.getId());
                param.setSourceType(PZ_SOURCETYPE);
                param.setFilePathList(pzList);
                logger.info("PZ参数：" +JSONObject.toJSONString(param));
                CommonResponse<String> pzRes = attachmentApi.uploadFileFormNet(param);
                logger.info("PZ返回结果：" +pzRes.getData());
            }
        }
        return "";
    }

    public String uploadDetailImg(PushWeighbillVO weighbillVO){
        List<WeighbillImgsVO> imgVOList = weighbillVO.getWeighImgs();
        List<WeighbillImgEntity> imgEntities = new ArrayList<>();
        if(CollectionUtils.isNotEmpty(imgVOList)){
            imgVOList.forEach(e->{
                WeighbillImgEntity weighbillImgEntity = BeanMapper.map(e,WeighbillImgEntity.class);
                weighbillImgEntity.setThirdWeighId(weighbillVO.getThirdWeighId());
                weighbillImgEntity.setSourceSystem(weighbillVO.getSourceSystem());
                weighbillImgEntity.setWeightId(weighbillVO.getId());
                imgEntities.add(weighbillImgEntity);
            });
            weighbillImgService.saveOrUpdateBatch(imgEntities);
        }
        return "";
    }

}
