package com.ejianc.business.weigh.weighbill.controller;

import java.io.Serializable;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.weigh.weighbill.enums.CheckStatusEnum;
import com.ejianc.business.weigh.weighbill.vo.DelWeighbillVO;
import com.ejianc.business.weigh.weighbill.vo.PushWeighbillVO;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.kit.collection.ListUtil;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.*;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.apache.commons.collections.CollectionUtils;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;

import com.ejianc.business.weigh.weighbill.bean.WeighbillEntity;
import com.ejianc.business.weigh.weighbill.service.IWeighbillService;
import com.ejianc.business.weigh.weighbill.vo.WeighbillVO;

/**
 * 磅单实体
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("weigh")
@Api(value = "磅单实体", tags = {"磅单实体"})
public class WeighbillController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IOrgApi iOrgApi;

//    private static final String BILL_CODE = "Invoice_Open_Apply_Code";//此处需要根据实际修改

    @Autowired
    private IWeighbillService service;

    @Autowired
    private SessionManager sessionManager;

    @ApiOperation("新增或者修改")
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<WeighbillVO> saveOrUpdate(@ApiParam(name="saveOrUpdateVO", required=true) @RequestBody WeighbillVO saveOrUpdateVO) {
    	WeighbillEntity entity = BeanMapper.map(saveOrUpdateVO, WeighbillEntity.class);
//    	if(entity.getId() == null || entity.getId() == 0){
//            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE,InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
//            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
//            if(billCode.isSuccess()) {
//                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
//            }else{
//                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
//            }
//        }
    	service.saveOrUpdate(entity, false);
    	WeighbillVO vo = BeanMapper.map(entity, WeighbillVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }


    @ApiOperation("推送磅单接口")
    @RequestMapping(value = "/pushWeigh", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> saveWeigh(@ApiParam(name="weighVO", required=true) @RequestBody PushWeighbillVO weighVO) {
        return service.saveWeigh(weighVO);
    }

    @ApiOperation("删除磅单接口")
    @RequestMapping(value = "/delWeigh", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> deleteWeigh(@ApiParam(name="weighVO", required=true) @RequestBody DelWeighbillVO weighVO) {
        return service.deleteWeigh(weighVO);
    }

    @ApiOperation("推送磅单图片接口")
    @RequestMapping(value = "/syncImgs", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> saveWeighImgs(@ApiParam(name="weighVO", required=true) @RequestBody PushWeighbillVO weighVO) {
        return service.saveWeighImgs(weighVO);
    }

    @ApiOperation("查询详情")
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<WeighbillVO> queryDetail(@RequestParam Long id) {
    	WeighbillEntity entity = service.selectById(id);
    	WeighbillVO vo = BeanMapper.map(entity, WeighbillVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }


    @ApiOperation("批量删除单据")
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<WeighbillVO> vos) {
        if(ListUtil.isNotEmpty(vos)){
            for (WeighbillVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
            }
        }
        service.removeByIds(vos.stream().map(WeighbillVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }


    @ApiOperation("查询列表")
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<WeighbillVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("weightCode");
        fuzzyFields.add("plateNumber");
        fuzzyFields.add("projectName");
        fuzzyFields.add("supplierName");
        fuzzyFields.add("contractName");
        fuzzyFields.add("materialTypeName");
        fuzzyFields.add("materialName");
        fuzzyFields.add("deliveryCode");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
        List<Long> commonOrgIds = new ArrayList<>();
        Long orgId = InvocationInfoProxy.getOrgId();
        CommonResponse<List<OrgVO>> orgListResp = iOrgApi.findChildrenByParentId(orgId);
        if (!orgListResp.isSuccess()) {
            return CommonResponse.success("查询组织信息失败！");
        }
        commonOrgIds.addAll(orgListResp.getData().stream().map(OrgVO::getId).collect(Collectors.toList()));
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(commonOrgIds)) {
            param.getParams().put("orgId", new Parameter(QueryParam.IN, commonOrgIds));
        }

        IPage<WeighbillEntity> page = service.queryPage(param,false);
        IPage<WeighbillVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), WeighbillVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }


    @ApiOperation("根据发货主键查询磅单信息")
    @RequestMapping(value = "/queryListBydeliveryId", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<WeighbillVO>> queryListBydeliveryId(@RequestParam Long deliveryId,@RequestParam int checkStatus) {
        List<WeighbillVO> res = new ArrayList<>();
        List<WeighbillEntity> list = null;
        if(0==checkStatus){
            list = service.list(new QueryWrapper<WeighbillEntity>().eq("delivery_id",deliveryId).eq("check_status",0));
        }else{
            list = service.list(new QueryWrapper<WeighbillEntity>().eq("delivery_id",deliveryId));
        }
        if(CollectionUtils.isNotEmpty(list)){
            res = BeanMapper.mapList(list,WeighbillVO.class);
        }

        return CommonResponse.success("查询数据成功！",res);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    @ApiOperation("导出")
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("weightCode");
        fuzzyFields.add("plateNumber");
        fuzzyFields.add("projectName");
        fuzzyFields.add("supplierName");
        fuzzyFields.add("contractName");
        fuzzyFields.add("materialTypeName");
        fuzzyFields.add("materialName");
        fuzzyFields.add("deliveryCode");
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<WeighbillEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        List<WeighbillVO> weighbillVOS = new ArrayList<>();
        if(CollectionUtils.isNotEmpty(list)){
            weighbillVOS = BeanMapper.mapList(list, WeighbillVO.class);
            for (WeighbillVO weighbillVO : weighbillVOS) {
                weighbillVO.setCheckStatusName(CheckStatusEnum.getEnumByCode(weighbillVO.getCheckStatus()).getDescription());
            }
        }
        beans.put("records", weighbillVOS);
        ExcelExport.getInstance().export("Weigh-export.xlsx", beans, response);
    }


    @ApiOperation("参照")
    @RequestMapping(value = "/refWeighData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<WeighbillVO>> refWeighData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                           String condition,
                                                           String searchObject,
                                                           String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<WeighbillEntity> page = service.queryPage(param,false);
        IPage<WeighbillVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), WeighbillVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }
}
