package com.ejianc.business.weigh.weighbill.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.weigh.weighbill.bean.WeighbillEntity;
import com.ejianc.business.weigh.weighbill.gldVo.*;
import com.ejianc.business.weigh.weighbill.mapper.WeighbillMapper;
import com.ejianc.business.weigh.weighbill.service.IPushDataToThirdService;
import com.ejianc.business.weigh.weighbill.vo.DeliveryDetailThirdVO;
import com.ejianc.business.weigh.weighbill.vo.DeliveryThirdVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.glodon.cloudt.rest.client.RestServiceClient;
import com.glodon.cloudt.rest.client.data.HmacRestAuthInfo;
import com.glodon.cloudt.rest.client.data.RestResponseInfo;
import com.glodon.cloudt.rest.client.exception.AuthenticateException;
import com.glodon.cloudt.rest.client.exception.InvalidUriException;
import com.glodon.cloudt.rest.client.exception.NoAuthenticateException;
import com.glodon.cloudt.rest.client.impl.HmacRestServiceClient;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.ClassPathResource;
import org.springframework.stereotype.Service;

import java.io.IOException;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;

/**
 * 磅单实体
 * 
 * @author sunyj
 * 
 */
@Service("pushDataToGLDService")
public class PushDataToGLDServiceImpl extends BaseServiceImpl<WeighbillMapper, WeighbillEntity> implements IPushDataToThirdService {

    private Logger logger = LoggerFactory.getLogger(this.getClass());


    private static final String API_URL_ORDER = "/gys/material-track/order/batchSave";//订单api接口

    private static final String API_URL_WAYBILL = "/gys/gems-web-api/waybillApi/batchSaveWaybills";//运单api接口
    @Value("${common.env.base-host}")
    private String BaseHost;

    @Override
    public CommonResponse<String> pushDataToThird(DeliveryThirdVO deliveryThirdVO) {
        logger.info("推送GLD订单数据入参：{}",JSONObject.toJSONString(deliveryThirdVO));
        //一，推送订单
        CommonResponse<String> orderRes = pushOrder(deliveryThirdVO);
        if (!orderRes.isSuccess()) {
            return CommonResponse.error(orderRes.getMsg());
        }
        //二，推送运单
//        CommonResponse<String> wayBillRes = pushWayBill(deliveryThirdVO);
//        if (!wayBillRes.isSuccess()) {
//            return CommonResponse.error(wayBillRes.getMsg());
//        }
        return CommonResponse.success("推送成功");
    }


    public CommonResponse<String> pushOrder(DeliveryThirdVO deliveryThirdVO) {
        //一，推送订单
        try {
            /**----------------准备 -------------------*/
            //第1步：下载授权文件
            //第2步：获取SDK

            /** ------------ 授权认证 --------------*/
            //第3步：创建客户端实例
            RestServiceClient serviceClient = HmacRestServiceClient.getInstance();
            //第4步：加载/验证授权文件
            //4.1构建认证信息
            HmacRestAuthInfo restAuthInfo = new HmacRestAuthInfo();
            //4.2设置授权文件路径
            String authInfoPath = "authFileProd/auth.lic";
//            if (BaseHost.contains("https://qlh.baju.com.cn")) {
//                authInfoPath = "authFileProd/auth.lic";
//                logger.info("获取授权文件-----：{}", authInfoPath);
//            } else {
////                authInfoPath = "E:\\auth.lic";
//                authInfoPath = "authFileTest/auth.lic";
//                logger.info("获取授权文件-----：{}", authInfoPath);
//            }
//            restAuthInfo.setLicPath(authInfoPath);
            ClassPathResource resource = new ClassPathResource(authInfoPath);
            restAuthInfo.setLicStream(resource.getInputStream());
            //4.3权限认证
            serviceClient.authenticate(restAuthInfo);

            /** ------------ 拼接请求地址 --------------*/
            //第5步：获取授权文件关联的GYS系统地址hostAddress
            String hostAddress = serviceClient.getRestRootAddress();
            //第6步：设置请求接口的URI地址apiURI(以获取集成项目列表信息为例)
            //第7步：拼装完整的请求网址
            String orderURL = hostAddress + API_URL_ORDER;
            //第8步：请求数据准备（本例中为从GYS系统获取数据，无需进行请求数据的准备）

            //第9步：发送请求，用来推送/获取数据
            PushGLDOrderVO orderVO = changeOrderVo(deliveryThirdVO);
            List<PushGLDOrderVO> list = new ArrayList<>();
            list.add(orderVO);
            logger.info("推送GLD订单数据URL：{}", orderURL);
            logger.info("推送GLD订单数据参数参数：{}", JSONObject.toJSONString(list));
            RestResponseInfo restResponseInfo = serviceClient.post(orderURL, JSONObject.toJSONString(list));

            /** ------------ 处理请求返回结果 --------------*/
            if (restResponseInfo.isSuccess()) {
                //请求成功：
                //第10步：处理请求结果（第三方系统自行处理）
                logger.info("GLD订单返回数据--：{}", restResponseInfo.getStringContent());
                PushGLDErrorVO pushGLDErrorVO = JSONObject.parseObject(restResponseInfo.getStringContent(), PushGLDErrorVO.class);
                if (500 == pushGLDErrorVO.getCode()) {
                    return CommonResponse.error( "推送广联达订单接口异常,异常信息：" + pushGLDErrorVO.getMessage());
                } else if (CollectionUtils.isNotEmpty(pushGLDErrorVO.getData().getErrorList())) {
                    return CommonResponse.error( "推送广联达订单接口异常！,异常信息：" + pushGLDErrorVO.getData().getErrorList().get(0).getErrMsg());
                }
            } else {
                //请求失败:
                //第11步：拼接完整的上报请求失败地址
                String faultLogApiURI = "/gys/tl/services/trace/api-fault-log";
                String faultLogFullURL = hostAddress + faultLogApiURI;
                //第12步：构建上报请求失败数据
                JSONObject faultLog = new JSONObject();
                faultLog.put("requestUrl", orderURL);
                faultLog.put("requestMethod", "POST");
                faultLog.put("requestBody", "");
                faultLog.put("statusCode", restResponseInfo.getErrorCode());
                faultLog.put("response", restResponseInfo.getStringContent());
                faultLog.put("description", restResponseInfo.getErrorMessage());
                DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyyMMddHHmmss");//时间戳格式，到秒
                LocalDateTime dateTime = LocalDateTime.now();
                String searchKey = formatter.format(dateTime);
                faultLog.put("searchKey", searchKey);  //能表征本次请求记录的标识，方便进行问题排查
                //第13步：上报请求失败数据
                serviceClient.post(faultLogFullURL, faultLog.toJSONString());
                return CommonResponse.error( "推送广联达订单接口异常,异常信息：" + restResponseInfo.getErrorMessage());
            }
        } catch (AuthenticateException e) {
            e.printStackTrace();
            return CommonResponse.error( "推送广联达订单接口异常,异常信息：" + e.getMessage());
        } catch (InvalidUriException e) {
            e.printStackTrace();
            return CommonResponse.error( "推送广联达订单接口异常,异常信息：" + e.getMessage());
        } catch (NoAuthenticateException e) {
            e.printStackTrace();
            return CommonResponse.error( "推送广联达订单接口异常,异常信息：" + e.getMessage());
        }catch (IOException e) {
            e.printStackTrace();
            return CommonResponse.error( "推送广联达订单接口异常,异常信息：" + e.getMessage());
        }
        return CommonResponse.success("推送订单成功");
    }

//    public CommonResponse<String> pushWayBill(DeliveryThirdVO deliveryThirdVO) {
//        try {
//            /**----------------准备 -------------------*/
//            //第1步：下载授权文件
//            //第2步：获取SDK
//
//            /** ------------ 授权认证 --------------*/
//            //第3步：创建客户端实例
//            RestServiceClient serviceClient = HmacRestServiceClient.getInstance();
//            //第4步：加载/验证授权文件
//            //4.1构建认证信息
//            HmacRestAuthInfo restAuthInfo = new HmacRestAuthInfo();
//            //4.2设置授权文件路径
//            String authInfoPath = "";
//            if (BaseHost.contains("https://pm.ynsbj.com/")) {
//                authInfoPath = "authFileProd/auth.lic";
//            } else {
////                authInfoPath = "E:\\auth.lic";
//                authInfoPath = "authFileTest/auth.lic";
//            }
//            ClassPathResource resource = new ClassPathResource(authInfoPath);
//            restAuthInfo.setLicStream(resource.getInputStream());
////            restAuthInfo.setLicPath(authInfoPath);
//            //4.3权限认证
//            serviceClient.authenticate(restAuthInfo);
//
//            /** ------------ 拼接请求地址 --------------*/
//            //第5步：获取授权文件关联的GYS系统地址hostAddress
//            String hostAddress = serviceClient.getRestRootAddress();
//            //第6步：设置请求接口的URI地址apiURI(以获取集成项目列表信息为例)
//            //第7步：拼装完整的请求网址
//            String orderURL = hostAddress + API_URL_WAYBILL;
//            //第8步：请求数据准备（本例中为从GYS系统获取数据，无需进行请求数据的准备）
//
//            //第9步：发送请求，用来推送/获取数据
//            PushGLDWayBillVO wayBillVO = changeWayBillVo(deliveryThirdVO);
//            List<PushGLDWayBillVO> list = new ArrayList<>();
//            list.add(wayBillVO);
//            logger.info("推送GLD运单数据URL：{}", orderURL);
//            logger.info("推送GLD运单数据参数参数：{}", JSONObject.toJSONString(list));
//            RestResponseInfo restResponseInfo = serviceClient.post(orderURL, JSONObject.toJSONString(list));
//
//            /** ------------ 处理请求返回结果 --------------*/
//            if (restResponseInfo.isSuccess()) {
//                //请求成功：
//                //第10步：处理请求结果（第三方系统自行处理）
//                logger.info("GLD运单返回数据--：{}", restResponseInfo.getStringContent());
//                PushGLDErrorVO pushGLDErrorVO = JSONObject.parseObject(restResponseInfo.getStringContent(), PushGLDErrorVO.class);
//                if (500 == pushGLDErrorVO.getCode()) {
//                    return CommonResponse.error( "推送广联达运单接口异常,异常信息：" + pushGLDErrorVO.getMessage());
//                } else if (CollectionUtils.isNotEmpty(pushGLDErrorVO.getData().getErrorList())) {
//                    return CommonResponse.error( "推送广联达运单接口异常！,异常信息：" + pushGLDErrorVO.getData().getErrorList().get(0).getErrMsg());
//                }
//            } else {
//                //请求失败:
//                //第11步：拼接完整的上报请求失败地址
//                String faultLogApiURI = "/gys/tl/services/trace/api-fault-log";
//                String faultLogFullURL = hostAddress + faultLogApiURI;
//                //第12步：构建上报请求失败数据
//                JSONObject faultLog = new JSONObject();
//                faultLog.put("requestUrl", orderURL);
//                faultLog.put("requestMethod", "POST");
//                faultLog.put("requestBody", "");
//                faultLog.put("statusCode", restResponseInfo.getErrorCode());
//                faultLog.put("response", restResponseInfo.getStringContent());
//                faultLog.put("description", restResponseInfo.getErrorMessage());
//                DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyyMMddHHmmss");//时间戳格式，到秒
//                LocalDateTime dateTime = LocalDateTime.now();
//                String searchKey = formatter.format(dateTime);
//                faultLog.put("searchKey", searchKey);  //能表征本次请求记录的标识，方便进行问题排查
//                //第13步：上报请求失败数据
//                serviceClient.post(faultLogFullURL, faultLog.toJSONString());
//                return CommonResponse.error( "推送广联达运单接口异常,异常信息：" + restResponseInfo.getErrorMessage());
//            }
//        } catch (AuthenticateException e) {
//            e.printStackTrace();
//            return CommonResponse.error( "推送广联达运单接口异常,异常信息：" + e.getMessage());
//        } catch (InvalidUriException e) {
//            e.printStackTrace();
//            return CommonResponse.error( "推送广联达运单接口异常,异常信息：" + e.getMessage());
//        } catch (NoAuthenticateException e) {
//            e.printStackTrace();
//            return CommonResponse.error( "推送广联达运单接口异常,异常信息：" + e.getMessage());
//        }catch (IOException e) {
//            e.printStackTrace();
//            return CommonResponse.error( "推送广联达订单接口异常,异常信息：" + e.getMessage());
//        }
//        return CommonResponse.success("推送运单成功");
//    }

    public PushGLDOrderVO changeOrderVo(DeliveryThirdVO deliveryThirdVO){
        PushGLDOrderVO pushGLDOrderVO = new PushGLDOrderVO();
        pushGLDOrderVO.setUnitId(deliveryThirdVO.getId().toString());
        pushGLDOrderVO.setSyncCode(deliveryThirdVO.getSyncCode());
        pushGLDOrderVO.setOrderNum(deliveryThirdVO.getBillCode());
        pushGLDOrderVO.setProviderUnitId(deliveryThirdVO.getSupplierSourceId());
        pushGLDOrderVO.setProviderName(deliveryThirdVO.getSupplierName());
        pushGLDOrderVO.setCreater(deliveryThirdVO.getEmployeeName()==null?deliveryThirdVO.getCreateUserCode():deliveryThirdVO.getEmployeeName());
        pushGLDOrderVO.setProjectName(deliveryThirdVO.getCustomerName());
//        pushGLDOrderVO.setContractUnitId(deliveryThirdVO.getContractId().toString());
//        pushGLDOrderVO.setContractCode(deliveryThirdVO.getContractCode());
//        pushGLDOrderVO.setContractName(deliveryThirdVO.getContractName());
        pushGLDOrderVO.setAddress(deliveryThirdVO.getOrderAddress());
        pushGLDOrderVO.setOptFlag(deliveryThirdVO.getOptFlag());

        List<DeliveryDetailThirdVO> detailList = deliveryThirdVO.getDetailList();
        if(CollectionUtils.isNotEmpty(detailList)){
            List<PushGLDOrderDetailVO> orderMaterials = new ArrayList<>();
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            detailList.forEach(e->{
                PushGLDOrderDetailVO pushGLDOrderDetailVO = new PushGLDOrderDetailVO();
                pushGLDOrderDetailVO.setUnitId("CL&"+e.getId().toString());
                pushGLDOrderDetailVO.setUnitPid(e.getOrderId().toString());
                pushGLDOrderDetailVO.setMaterialUnitId(e.getMaterialSourceId());
                pushGLDOrderDetailVO.setMaterialCode(e.getMaterialCode().toString());
                pushGLDOrderDetailVO.setMaterialName(e.getMaterialName().toString());
                pushGLDOrderDetailVO.setUnit(e.getUnit());
                pushGLDOrderDetailVO.setSpecification(e.getSpec());
                pushGLDOrderDetailVO.setOrderQuantity(e.getOrderNumsSum());
                pushGLDOrderDetailVO.setIncomeDate(simpleDateFormat.format(deliveryThirdVO.getOrderExpiryDate()));
                orderMaterials.add(pushGLDOrderDetailVO);
            });
            pushGLDOrderVO.setOrderMaterials(orderMaterials);
        }
        return pushGLDOrderVO;
    }

//    public PushGLDWayBillVO changeWayBillVo(DeliveryThirdVO deliveryThirdVO){
//        PushGLDWayBillVO pushGLDWayBillVO = new PushGLDWayBillVO();
//        pushGLDWayBillVO.setUnitId(deliveryThirdVO.getId().toString());
//        pushGLDWayBillVO.setSyncCode(deliveryThirdVO.getSyncCode());
//        pushGLDWayBillVO.setWaybillNum(deliveryThirdVO.getBillCode());
//        pushGLDWayBillVO.setProviderUnitId(deliveryThirdVO.getSupplierId().toString());
//        pushGLDWayBillVO.setCarNum(deliveryThirdVO.getLicensePlate()==null?"京A00000":deliveryThirdVO.getLicensePlate());
//        pushGLDWayBillVO.setOrderUnitId(deliveryThirdVO.getId().toString());
//        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
//        pushGLDWayBillVO.setWaybillSubmitTime(simpleDateFormat.format(deliveryThirdVO.getArriveDate()));
//        pushGLDWayBillVO.setStatus(1);
//        pushGLDWayBillVO.setAddress(deliveryThirdVO.getOrderAddress());
//        pushGLDWayBillVO.setOptFlag(0);
//        List<DeliveryDetailThirdVO> detailList = deliveryThirdVO.getDetailList();
//        if(CollectionUtils.isNotEmpty(detailList)){
//            List<PushGLDWayBillDetailVO> waybillMaterials = new ArrayList<>();
//            detailList.forEach(e->{
//                PushGLDWayBillDetailVO pushGLDWayBillDetailVO = new PushGLDWayBillDetailVO();
//                pushGLDWayBillDetailVO.setUnitId(e.getId().toString());
//                pushGLDWayBillDetailVO.setUnitPid(e.getDeliveryId().toString());
//                pushGLDWayBillDetailVO.setMaterialUnitId(e.getMaterialId().toString());
//                pushGLDWayBillDetailVO.setMaterialCode(e.getMaterialCode().toString());
//                pushGLDWayBillDetailVO.setMaterialName(e.getMaterialName().toString());
//                pushGLDWayBillDetailVO.setUnit(e.getUnit());
//                pushGLDWayBillDetailVO.setSpecification(e.getSpec());
//                pushGLDWayBillDetailVO.setWayBillQuantity(e.getDeliveryNum());
//                waybillMaterials.add(pushGLDWayBillDetailVO);
//            });
//            pushGLDWayBillVO.setWaybillMaterials(waybillMaterials);
//        }
//        return pushGLDWayBillVO;
//    }
}
