/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.progress.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.progress.bean.WorkItemEntity;
import com.ejianc.business.progress.mapper.WorkItemMapper;
import com.ejianc.business.progress.service.IWorkItemService;
import com.ejianc.business.progress.utils.TreeNodeBUtil;
import com.ejianc.business.progress.vo.WorkItemVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="workItemService")
public class WorkItemServiceImpl
extends BaseServiceImpl<WorkItemMapper, WorkItemEntity>
implements IWorkItemService {
    @Autowired
    private WorkItemMapper workItemMapper;

    @Override
    public List<WorkItemVO> detailRef(Long stageId) {
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"stage_id", (Object)stageId);
        List entities = ((WorkItemMapper)this.baseMapper).selectList((Wrapper)wrapper);
        if (entities != null && entities.size() > 0) {
            for (WorkItemEntity workItemEntity : entities) {
                workItemEntity.setTid(workItemEntity.getId().toString());
                workItemEntity.setTpid(workItemEntity.getParentId() != null && workItemEntity.getParentId() > 0L ? workItemEntity.getParentId().toString() : "");
            }
        }
        List detailVos = BeanMapper.mapList((Iterable)entities, WorkItemVO.class);
        return TreeNodeBUtil.buildTree((List)detailVos);
    }

    @Override
    public CommonResponse<WorkItemVO> saveOrUpdate(WorkItemVO workItemVO) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        LambdaQueryWrapper lambdaQueryWrapper = Wrappers.lambdaQuery();
        lambdaQueryWrapper.eq(BaseEntity::getTenantId, (Object)tenantId);
        lambdaQueryWrapper.eq(WorkItemEntity::getStageId, (Object)workItemVO.getStageId());
        if (workItemVO.getId() != null && workItemVO.getId() > 0L) {
            lambdaQueryWrapper.ne(BaseEntity::getId, (Object)workItemVO.getId());
        }
        return CommonResponse.success((String)"\u4fdd\u5b58\u6210\u529f");
    }

    @Override
    public List<WorkItemVO> queryStageDetail(Long stageId) {
        List<WorkItemVO> workItemVOS = ((WorkItemMapper)this.baseMapper).queryStageDetail(stageId);
        return workItemVOS;
    }

    @Override
    public List<WorkItemVO> queryListByPid(Long id) {
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"parent_id", (Object)id);
        List entities = this.workItemMapper.selectList((Wrapper)wrapper);
        if (entities != null) {
            return BeanMapper.mapList((Iterable)entities, WorkItemVO.class);
        }
        return null;
    }
}

