package com.ejianc.business.supbusiness.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * 消耗材-发货单
 *
 * @author generator
 *
 */
@ApiModel("消耗材-发货单")
public class DeliveryDbVO {
    private static final long serialVersionUID = 1L;

    private Long sourceId; // 来源发货单主键
    private Long orderId; // 订单主键
    private String orderBillCode; // 订单单据编号
    private String billCode; // 单据编号
    private Long contractId; // 合同主键
    private String contractName; // 合同名称
    private String contractCode; // 合同编码
    private Long projectId; // 项目
    private String projectName; // 项目名称
    private String projectCode; // 项目编码
    private Long supplierId; // 供应商主键
    private String supplierName; // 供应商名称
    private Long employeeId; // 经办人
    private String employeeName; // 经办人名称
    private String deliverName; // 送货人名称
    private String deliverPhone; // 送货人联系电话
    private Date deliverDate; // 送货日期
    private Date arriveDate; // 预计到货日期
    private String licensePlate; // 车牌号
    private Long departmentId; // 经办部门
    private String departmentName; // 经办部门名称
    private Integer closeFlag; // 是否关闭，0-否，1-是
    private Integer checkStatus; // 验收状态，0-待接收,1-部分接收,2-已验收
    private Long orgId; // 组织
    private String orgName; // 组织名称
    private String memo; // 备注
    private String materialName; // 发货内容
    private String construction; // 使用部位
    private String parentOrgName; // 父级组织名称
    private Long parentOrgId; // 父级组织
    private Integer billState; // 单据状态（审批必须字段）
    private String isPushThird; // 推送第三方是否成功 sucPushed   unSucPush
    private Integer automaticWeigh; // 自动称重设置（0：自动称重，1非自动称重）
    private String unSucReason; // 推送第三方失败原因
    private String platformType; // 磅点类型
    private String platformCode; // 磅点编号
    private Integer deliveryType; // 发货单类型 1-自制，2-供方推送（订单）
    private Long linkId; // 订单联系人
    private String linkName; // 订单联系人名称
    private Date orderExpiryDate; // 订单要求到货日期
    private Integer checkWeighNum; // 已验收磅单数量
    private Integer weighNum; // 磅单数量

    @ApiModelProperty("材料订单子表")
    private List<DeliveryDetailDbVO> materialDeliveryDetailList = new ArrayList<>();

    public Integer getCheckWeighNum() {
        return checkWeighNum;
    }

    public void setCheckWeighNum(Integer checkWeighNum) {
        this.checkWeighNum = checkWeighNum;
    }

    public Integer getWeighNum() {
        return weighNum;
    }

    public void setWeighNum(Integer weighNum) {
        this.weighNum = weighNum;
    }


    public String getUnSucReason() {
        return unSucReason;
    }

    public void setUnSucReason(String unSucReason) {
        this.unSucReason = unSucReason;
    }

    public Integer getAutomaticWeigh() {
        return automaticWeigh;
    }

    public void setAutomaticWeigh(Integer automaticWeigh) {
        this.automaticWeigh = automaticWeigh;
    }

    public String getIsPushThird() {
        return isPushThird;
    }

    public void setIsPushThird(String isPushThird) {
        this.isPushThird = isPushThird;
    }

    /**
     * 来源发货单主键
     */
    public Long getSourceId() {
        return sourceId;
    }

    /**
     * 来源发货单主键
     */
    public void setSourceId(Long sourceId) {
        this.sourceId = sourceId;
    }
    /**
     * 订单主键
     */
    public Long getOrderId() {
        return orderId;
    }

    /**
     * 订单主键
     */
    public void setOrderId(Long orderId) {
        this.orderId = orderId;
    }
    /**
     * 订单单据编号
     */
    public String getOrderBillCode() {
        return orderBillCode;
    }

    /**
     * 订单单据编号
     */
    public void setOrderBillCode(String orderBillCode) {
        this.orderBillCode = orderBillCode;
    }
    /**
     * 单据编号
     */
    public String getBillCode() {
        return billCode;
    }

    /**
     * 单据编号
     */
    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    /**
     * 合同主键
     */
//    @ReferSerialTransfer(referCode = "contractMaterial")
    public Long getContractId() {
        return contractId;
    }

    /**
     * 合同主键
     */
//    @ReferDeserialTransfer
    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }
    /**
     * 合同名称
     */
    public String getContractName() {
        return contractName;
    }

    /**
     * 合同名称
     */
    public void setContractName(String contractName) {
        this.contractName = contractName;
    }
    /**
     * 合同code
     */
    public String getContractCode() {
        return contractCode;
    }

    /**
     * 合同code
     */
    public void setContractCode(String contractCode) {
        this.contractCode = contractCode;
    }
    /**
     * 项目
     */
    public Long getProjectId() {
        return projectId;
    }

    /**
     * 项目
     */
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    /**
     * 项目名称
     */
    public String getProjectName() {
        return projectName;
    }

    /**
     * 项目名称
     */
    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    /**
     * 项目code
     */
    public String getProjectCode() {
        return projectCode;
    }

    /**
     * 项目code
     */
    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    /**
     * 供应商主键
     */
//    @ReferSerialTransfer(referCode = "support-supplier")
    public Long getSupplierId() {
        return supplierId;
    }

    /**
     * 供应商主键
     */
//    @ReferDeserialTransfer
    public void setSupplierId(Long supplierId) {
        this.supplierId = supplierId;
    }
    /**
     * 供应商名称
     */
    public String getSupplierName() {
        return supplierName;
    }

    /**
     * 供应商名称
     */
    public void setSupplierName(String supplierName) {
        this.supplierName = supplierName;
    }
    /**
     * 经办人
     */
//    @ReferSerialTransfer(referCode = "idm-employee")
    public Long getEmployeeId() {
        return employeeId;
    }

    /**
     * 经办人
     */
//    @ReferDeserialTransfer
    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    /**
     * 经办人名称
     */
    public String getEmployeeName() {
        return employeeName;
    }

    /**
     * 经办人名称
     */
    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    /**
     * 送货人名称
     */
    public String getDeliverName() {
        return deliverName;
    }

    /**
     * 送货人名称
     */
    public void setDeliverName(String deliverName) {
        this.deliverName = deliverName;
    }
    /**
     * 送货人联系电话
     */
    public String getDeliverPhone() {
        return deliverPhone;
    }

    /**
     * 送货人联系电话
     */
    public void setDeliverPhone(String deliverPhone) {
        this.deliverPhone = deliverPhone;
    }
    /**
     * 预计到货日期
     */
    public Date getArriveDate() {
        return arriveDate;
    }

    /**
     * 预计到货日期
     */
    public void setArriveDate(Date arriveDate) {
        this.arriveDate = arriveDate;
    }
    /**
     * 车牌号
     */
    public String getLicensePlate() {
        return licensePlate;
    }

    /**
     * 车牌号
     */
    public void setLicensePlate(String licensePlate) {
        this.licensePlate = licensePlate;
    }
    /**
     * 经办部门
     */
    public Long getDepartmentId() {
        return departmentId;
    }

    /**
     * 经办部门
     */
    public void setDepartmentId(Long departmentId) {
        this.departmentId = departmentId;
    }
    /**
     * 经办部门名称
     */
    public String getDepartmentName() {
        return departmentName;
    }

    /**
     * 经办部门名称
     */
    public void setDepartmentName(String departmentName) {
        this.departmentName = departmentName;
    }
    /**
     * 是否关闭，0-否，1-是
     */
    public Integer getCloseFlag() {
        return closeFlag;
    }

    /**
     * 是否关闭，0-否，1-是
     */
    public void setCloseFlag(Integer closeFlag) {
        this.closeFlag = closeFlag;
    }
    /**
     * 验收状态，0-待接收,1-部分接收,2-全部接收
     */
    public Integer getCheckStatus() {
        return checkStatus;
    }

    /**
     * 验收状态，0-待接收,1-部分接收,2-全部接收
     */
    public void setCheckStatus(Integer checkStatus) {
        this.checkStatus = checkStatus;
    }
    /**
     * 组织
     */
    public Long getOrgId() {
        return orgId;
    }

    /**
     * 组织
     */
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    /**
     * 组织名称
     */
    public String getOrgName() {
        return orgName;
    }

    /**
     * 组织名称
     */
    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    /**
     * 备注
     */
    public String getMemo() {
        return memo;
    }

    /**
     * 备注
     */
    public void setMemo(String memo) {
        this.memo = memo;
    }
    /**
     * 使用部位
     */
    public String getConstruction() {
        return construction;
    }

    /**
     * 使用部位
     */
    public void setConstruction(String construction) {
        this.construction = construction;
    }
    /**
     * 父级组织名称
     */
    public String getParentOrgName() {
        return parentOrgName;
    }

    /**
     * 父级组织名称
     */
    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    /**
     * 父级组织
     */
    public Long getParentOrgId() {
        return parentOrgId;
    }

    /**
     * 父级组织
     */
    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    /**
     * 单据状态（审批必须字段）
     */
    public Integer getBillState() {
        return billState;
    }

    /**
     * 单据状态（审批必须字段）
     */
    public void setBillState(Integer billState) {
        this.billState = billState;
    }

    public Date getDeliverDate() {
        return deliverDate;
    }

    public void setDeliverDate(Date deliverDate) {
        this.deliverDate = deliverDate;
    }

    public String getMaterialName() {
        return materialName;
    }

    public void setMaterialName(String materialName) {
        this.materialName = materialName;
    }

    public String getPlatformType() {
        return platformType;
    }

    public void setPlatformType(String platformType) {
        this.platformType = platformType;
    }

    public String getPlatformCode() {
        return platformCode;
    }

    public void setPlatformCode(String platformCode) {
        this.platformCode = platformCode;
    }

    public Integer getDeliveryType() {
        return deliveryType;
    }

    public void setDeliveryType(Integer deliveryType) {
        this.deliveryType = deliveryType;
    }

    public Long getLinkId() {
        return linkId;
    }

    public void setLinkId(Long linkId) {
        this.linkId = linkId;
    }

    public String getLinkName() {
        return linkName;
    }

    public void setLinkName(String linkName) {
        this.linkName = linkName;
    }

    public Date getOrderExpiryDate() {
        return orderExpiryDate;
    }

    public void setOrderExpiryDate(Date orderExpiryDate) {
        this.orderExpiryDate = orderExpiryDate;
    }

    public List<DeliveryDetailDbVO> getMaterialDeliveryDetailList() {
        return materialDeliveryDetailList;
    }

    public void setMaterialDeliveryDetailList(List<DeliveryDetailDbVO> materialDeliveryDetailList) {
        this.materialDeliveryDetailList = materialDeliveryDetailList;
    }
}
